% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/action.R, R/action_artifacts.R,
%   R/action_artifacts_delete.R, R/action_artifacts_download.R, R/action_runs.R,
%   R/action_runtime.R, R/action_workflows.R
\name{action}
\alias{action}
\alias{action_artifacts}
\alias{action_artifact_delete}
\alias{action_artifact_download}
\alias{action_runs}
\alias{action_status}
\alias{action_runtime}
\alias{action_workflows}
\title{Retrieve information about GitHub Actions workflows and their runs.}
\usage{
action_artifacts(repo, keep_expired = FALSE, which = c("latest", "all"))

action_artifact_delete(repo, ids)

action_artifact_download(
  repo,
  dir,
  ids = action_artifacts(repo),
  keep_zip = FALSE,
  file_pat = "",
  overwrite = FALSE
)

action_runs(
  repo,
  branch = NULL,
  event = NULL,
  status = NULL,
  created = NULL,
  limit = 1
)

action_status(
  repo,
  branch = NULL,
  event = NULL,
  status = NULL,
  created = NULL,
  limit = 1
)

action_runtime(
  repo,
  branch = NULL,
  event = NULL,
  status = NULL,
  created = NULL,
  limit = 1
)

action_workflows(repo, full = FALSE)
}
\arguments{
\item{repo}{Character. Address of repository in \code{owner/name} format.}

\item{keep_expired}{Logical. Should expired artifacts be returned.}

\item{which}{Character. Either \code{"latest"} to return only the most recent of each
artifact or \code{"all"} to return all artifacts.}

\item{ids}{Integer or data frame. Artifact ids to be downloaded or deleted.
If a data frame is passed then the \code{id} column will be used.}

\item{dir}{Character. Path to the directory where artifacts will be saved.}

\item{keep_zip}{Logical. Should the artifact zips be saved (\code{TRUE}) or their contents (\code{FALSE}).}

\item{file_pat}{Character. If extracting zip with multiple files, regexp pattern to match filename.}

\item{overwrite}{Logical. Should existing files be overwritten.}

\item{branch}{Character. Filter runs associated with a particular branch.}

\item{event}{Character. Filter runs for triggered by a specific event. See
\href{https://docs.github.com/en/actions/automating-your-workflow-with-github-actions/events-that-trigger-workflows}{here}
for possible event names.}

\item{status}{Character. Filter runs for a particular status or conclusion (e.g. \code{completed} or \code{success}).}

\item{created}{Character. Filter runs for a given creation date.
See \href{https://docs.github.com/en/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates}{here}
for date query syntax.}

\item{limit}{Numeric. Maximum number of workflow runs to return. Default \code{1}. Note results
are chronologically ordered, so \code{limit = 1} will return the most recent action run for a repository.}

\item{full}{Logical. Should all workflow columns be returned. Default \code{FALSE}.}
}
\value{
\code{action_workflows()}, \code{action_runs()}, \code{action_runtime()}, and \code{action_artifacts}
all return tibbles containing information on requested repos' available workflows,
recent workflow runs, workflow runs runtimes, and generated artifacts
respectively.

\code{action_artifact_download()} returns a character vector containing the paths of all
downloaded fules

\code{action_artifact_delete()} returns an invisible data frame containing repository names and
ids of the deleted artifacts.
}
\description{
\itemize{
\item \code{action_workflows()} - retrieve details on repo workflows.
\item \code{action_runs()} - retrieve details on repo workflow runs.
\item \code{action_status()} - DEPRECATED - retrieve details on most recent workflow runs.
\item \code{action_runtime()} - retrieves runtime durations for workflow runs.
\item \code{action_artifacts()} - retrieve details on available workflow artifacts.
\item \code{action_artifact_download()} - downloads artifact(s) into a local directory.
\item \code{action_artifact_delete()} - deletes artifact(s).
}
}
\examples{
\dontrun{
action_workflows("rundel/ghclass")

action_runs("rundel/ghclass")

action_runtime(c("rundel/ghclass", "rundel/parsermd"))

action_artifacts(c("rundel/ghclass", "rundel/parsermd"))
}

}
