% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/element.R
\name{canvas}
\alias{canvas}
\title{Add a canvas specification to a ggplot object}
\usage{
canvas(
  width,
  height,
  units = c("in", "cm", "mm", "px"),
  dpi = 300,
  scale = 1,
  bg = "white"
)
}
\arguments{
\item{width, height}{Plot size in units expressed by the \code{units} argument.
If not supplied, uses the size of the current graphics device.}

\item{units}{One of the following units in which the \code{width} and \code{height}
arguments are expressed: \code{"in"}, \code{"cm"}, \code{"mm"} or \code{"px"}.}

\item{dpi}{Plot resolution. Also accepts a string input: "retina" (320),
"print" (300), or "screen" (72). Applies only to raster output types.}

\item{scale}{Multiplicative scaling factor.}

\item{bg}{Background colour. If \code{NULL}, uses the \code{plot.background} fill value
from the plot theme.}
}
\value{
An object of class \code{canvas} that can be added to a \code{ggplot} object
to specify the plot dimensions.
}
\description{
A canvas specification essentially comprises a set of parameters
from \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}. When a plot with this canvas specification is
printed, it is rendered as it would appear if saved to a file with the
specified dimensions.
}
\examples{
\dontshow{if (rstudioapi::isAvailable()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(ggplot2)
p <-
  ggplot(mtcars, aes(wt, mpg)) +
  geom_point() +
  ggtitle("My awesome plot")

p + canvas(3, 3)
p + canvas(5, 3, dpi = 400)
\dontshow{\}) # examplesIf}
}
