% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-smooth-tern.R, R/stat-smooth-tern.R
\docType{data}
\name{geom_smooth_tern}
\alias{GeomSmoothTern}
\alias{StatSmoothTern}
\alias{geom_smooth_tern}
\alias{stat_smooth_tern}
\title{Add a Smoothed Conditional Mean.}
\usage{
geom_smooth_tern(mapping = NULL, data = NULL, position = "identity", ...,
  method = "auto", formula = y ~ x, se = TRUE, na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE, expand = c(0.5, 0.5))

stat_smooth_tern(mapping = NULL, data = NULL, position = "identity", ...,
  method = "auto", formula = y ~ x, se = TRUE, n = 80, span = 0.75,
  fullrange = FALSE, level = 0.95, method.args = list(), na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE, expand = c(0.5, 0.5))
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{method}{smoothing method (function) to use, eg. "lm", "glm",
  "gam", "loess", "rlm".

  For \code{method = "auto"} the smoothing method is chosen based on the
  size of the largest group (across all panels). \code{\link{loess}} is
  used for than 1,000 observations; otherwise \code{\link[mgcv]{gam}} is
  used with \code{formula = y ~ s(x, bs = "cs")}. Somewhat anecdotally,
  \code{loess} gives a better appearance, but is O(n^2) in memory, so does
  not work for larger datasets.}

\item{formula}{formula to use in smoothing function, eg. \code{y ~ x},
\code{y ~ poly(x, 2)}, \code{y ~ log(x)}}

\item{se}{display confidence interval around smooth? (TRUE by default, see
level to control}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{expand}{expand the range of values by this much (vector of length 2) when fullrange is set to TRUE}

\item{n}{number of points to evaluate smoother at}

\item{span}{Controls the amount of smoothing for the default loess smoother.
Smaller numbers produce wigglier lines, larger numbers produce smoother
lines.}

\item{fullrange}{should the fit span the full range of the plot, or just
the data}

\item{level}{level of confidence interval to use (0.95 by default)}

\item{method.args}{List of additional arguments passed on to the modelling
function defined by \code{method}.}
}
\description{
Aids the eye in seeing patterns in the presence of overplotting.
\code{geom_smooth_tern} and \code{stat_smooth_tern} are effectively aliases: they
both use the same arguments. Use \code{geom_smooth_tern} unless you want to
display the results with a non-standard geom.
}
\examples{
data(Feldspar)
ggtern(data=Feldspar,aes(Ab,An,Or,group=Feldspar)) +  
  geom_smooth_tern(method=lm,fullrange=TRUE,colour='red') + 
  geom_point() +
  labs(title="Example Smoothing")
}
\author{
Nicholas Hamilton
}
\keyword{datasets}

