% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bugs_wide}
\alias{bugs_wide}
\title{Wide-format version of the "Bugs" dataset.}
\format{A data frame with 93 rows and 6 variables
\itemize{
\item subject. Dummy identity number for each participant.
\item gender. Participant's gender (Female, Male).
\item region. Region of the world the participant was from.
\item education. Level of education.
\item ldlf,ldhf,hdlf,hdhf.The desire to kill an arthropod was indicated on
a scale from 0 to 10 in each condition of the experiment (\strong{LDLF}: low
freighteningness and low disgustingness; \strong{LFHD}: low freighteningness and
high disgustingness; \strong{HFHD}: high freighteningness and low
disgustingness; \strong{HFHD}: high freighteningness and high disgustingness).
}}
\source{
\url{https://www.sciencedirect.com/science/article/pii/S0747563213000277}
}
\usage{
bugs_wide
}
\description{
Wide-format version of the "Bugs" dataset.
}
\details{
This data set, "Bugs", provides the extent to which men and women
want to kill arthropods that vary in freighteningness (low, high) and
disgustingness (low, high). Each participant rates their attitudes towards
all anthropods. Subset of the data reported by Ryan et al. (2013).
}
\examples{
dim(bugs_wide)
head(bugs_wide)
dplyr::glimpse(bugs_wide)
}
\keyword{datasets}
