% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_pairwise_comparison.R
\name{pairwise_p_caption}
\alias{pairwise_p_caption}
\title{Preparing caption in case pairwise comparisons are displayed.}
\usage{
pairwise_p_caption(type, var.equal = FALSE, paired = FALSE,
  p.adjust.method = "holm", caption = NULL)
}
\arguments{
\item{type}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}).Corresponding abbreviations are also accepted:
\code{"p"} (for parametric), \code{"np"} (nonparametric), \code{"r"} (robust), or
\code{"bf"}resp.}

\item{var.equal}{a logical variable indicating whether to treat the
    variances in the samples as equal.  If \code{TRUE}, then a simple F
    test for the equality of means in a one-way analysis of variance is
    performed.  If \code{FALSE}, an approximate method of Welch (1951)
    is used, which generalizes the commonly known 2-sample Welch test to
    the case of arbitrarily many samples.}

\item{paired}{a logical indicating whether you want a paired
    t-test.}

\item{p.adjust.method}{Adjustment method for \emph{p}-values for multiple
comparisons. Possible methods are: \code{"holm"} (default), \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.}

\item{caption}{The text for the plot caption.}
}
\description{
Preparing caption in case pairwise comparisons are displayed.
}
\keyword{internal}
