% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_ggpiestats.R
\name{grouped_ggpiestats}
\alias{grouped_ggpiestats}
\title{Grouped pie charts with statistical tests}
\usage{
grouped_ggpiestats(data, main, condition = NULL, counts = NULL,
  grouping.var, title.prefix = "Group", ratio = NULL,
  factor.levels = NULL, stat.title = NULL, sample.size.label = TRUE,
  caption = NULL, nboot = 25, palette = "Dark2", legend.title = NULL,
  facet.wrap.name = NULL, k = 3, facet.proptest = TRUE,
  ggtheme = ggplot2::theme_bw(), messages = TRUE, ...)
}
\arguments{
\item{data}{The data as a data frame (matrix or tables will not be accepted).}

\item{main}{The variable to use as the \strong{rows} in the
contingency table.}

\item{condition}{The variable to use as the \strong{columns} in the contingency
table. This argument is optional (Default: \code{NULL}). If this argument is
provided, then Pearson's chi-square test of independence will be run. If
not, a goodness of fit test will be run on the \code{main} variable.}

\item{counts}{A string naming a variable in data containing counts, or \code{NULL}
if each row represents a single observation (Default).}

\item{grouping.var}{Grouping variable.}

\item{title.prefix}{Character specifying the prefix text for the fixed plot
title (name of each factor level) (Default: \code{"Group"}).}

\item{ratio}{A vector of numbers: the expected proportions for the proportion
test. Default is \code{NULL}, which means if there are two levels \code{ratio = c(1,1)}, etc.}

\item{factor.levels}{A character vector with labels for factor levels of
\code{main} variable.}

\item{stat.title}{Title for the effect being investigated with the chi-square
test. The default is \code{NULL}, i.e. no title will be added to describe the
effect being shown. An example of a \code{stat.title} argument will be something
like \code{"main x condition"} or \code{"interaction"}.}

\item{sample.size.label}{Logical that decides whether sample size information
should be displayed for each level of the grouping variable \code{condition} (Default:
\code{TRUE}).}

\item{caption}{The text for the plot caption.}

\item{nboot}{Number of bootstrap samples for computing effect size (Default:
\code{25}).}

\item{palette}{If a character string (e.g., \code{"Set1"}), will use that named
palette. If a number, will index into the list of palettes of appropriate
type. Default palette is \code{"Dark2"}}

\item{legend.title}{Title of legend.}

\item{facet.wrap.name}{The text for the facet_wrap variable label.}

\item{k}{Number of decimal places expected for results.}

\item{facet.proptest}{Decides whether proportion test for \code{main} variable is
to be carried out for each level of \code{condition} (Default: \code{TRUE}).}

\item{ggtheme}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Allowed values are the official \code{ggplot2} themes,
including \code{theme_grey()}, \code{theme_minimal()}, \code{theme_classic()},
\code{theme_void()}, etc.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{...}{Arguments passed on to \code{combine_plots}
\describe{
  \item{title.text}{String or plotmath expression to be drawn as title for the
\emph{combined plot}.}
  \item{title.color}{Text color for title.}
  \item{title.size}{Point size of title text.}
  \item{title.vjust}{Vertical justification for title. Default = 0.5 (centered
on y). 0 = baseline at y, 1 = ascender at y.}
  \item{title.hjust}{Horizontal justification for title. Default = 0.5
(centered on x). 0 = flush-left at x, 1 = flush-right.}
  \item{title.fontface}{The font face ("plain", "bold", etc.) for title.}
  \item{caption.text}{String or plotmath expression to be drawn as the caption
for the \emph{combined plot}.}
  \item{caption.color}{Text color for caption.}
  \item{caption.size}{Point size of title text.}
  \item{caption.vjust}{Vertical justification for caption. Default = \code{0.5}
(centered on y). \code{0} = baseline at y, \code{1} = ascender at y.}
  \item{caption.hjust}{Horizontal justification for caption. Default = \code{0.5}
(centered on x). \code{0} = flush-left at x, \code{1} = flush-right.}
  \item{caption.fontface}{The font face (\code{"plain"}, \code{"bold"}, \code{"italic"},
\code{"bold.italic"}) for caption.}
  \item{sub.text}{The label with which the \emph{combined plot} should be annotated.
Can be a plotmath expression.}
  \item{sub.color}{Text color for annotation label.}
  \item{sub.size}{Point size of annotation text.}
  \item{sub.x}{The x position of annotation label.}
  \item{sub.y}{The y position of annotation label.}
  \item{sub.hjust}{Horizontal justification for annotation label.}
  \item{sub.vjust}{Vertical justification for annotation label.}
  \item{sub.vpadding}{Vertical padding. The total vertical space added to the
label, given in grid units. By default, this is added equally above and
below the label. However, by changing the y and vjust parameters, this can
be changed.}
  \item{sub.fontface}{The font face (\code{"plain"}, \code{"bold"}, \code{"italic"},
\code{"bold.italic"}) for the annotation label.}
  \item{sub.angle}{Angle at which annotation label is to be drawn.}
  \item{sub.lineheight}{Line height of annotation label.}
  \item{title.caption.rel.heights}{Numerical vector of relative columns heights
while combining (title, plot, caption).}
  \item{title.rel.heights}{Numerical vector of relative columns heights while
combining (title, plot).}
  \item{caption.rel.heights}{Numerical vector of relative columns heights while
combining (plot, caption).}
}}
}
\description{
Helper function for \code{ggstatsplot::ggpiestats} to apply this
function across multiple levels of a given factor and combining the
resulting plots using \code{ggstatsplot::combine_plots}.
}
\examples{

# grouped one-sample proportion tests
ggstatsplot::grouped_ggpiestats(
data = mtcars,
grouping.var = am,
main = cyl
)

}
\references{
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/ggpiestats.html}
}
\seealso{
\code{\link{ggpiestats}}
}
\author{
Indrajeet Patil
}
