% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggstackplot.R
\name{ggstackplot}
\alias{ggstackplot}
\alias{prepare_stackplot}
\alias{assemble_stackplot}
\title{Stack a ggplot}
\usage{
ggstackplot(
  data,
  x,
  y,
  remove_na = TRUE,
  color = NA,
  palette = NA,
  both_axes = FALSE,
  alternate_axes = TRUE,
  switch_axes = FALSE,
  overlap = 0,
  simplify_shared_axis = TRUE,
  shared_axis_size = 0.2,
  template = ggplot() + geom_line() + geom_point() + theme_stackplot(),
  add = list(),
  debug = FALSE
)

prepare_stackplot(
  data,
  x,
  y,
  remove_na = TRUE,
  color = NA,
  palette = NA,
  both_axes = FALSE,
  alternate_axes = TRUE,
  switch_axes = FALSE,
  template = ggplot() + geom_line() + geom_point() + theme_stackplot(),
  add = list(),
  debug = FALSE
)

assemble_stackplot(
  prepared_stackplot,
  overlap = 0,
  simplify_shared_axis = TRUE,
  shared_axis_size = 0.15,
  debug = FALSE
)
}
\arguments{
\item{data}{the data frame to plot}

\item{x}{the x variable(s) to plot, accepts \code{\link[dplyr:select]{dplyr::select()}} syntax. The order of variables is plotted from left to right (if multiple \code{x}).}

\item{y}{the y variable(s) to plot, accepts \code{\link[dplyr:select]{dplyr::select()}} syntax. The order of variables in plotted from top to bottom (if multiple \code{y}).}

\item{remove_na}{whether to remove \code{NA} values in the x/y plot, setting this to \code{FALSE} can lead to unintended side-effects for interrupted lines so check your plot carefully if you change this}

\item{color}{which color to make the plots (also sets the plotwide color and fill aesthetics, overwrite in individual geoms in the \code{template} to overwrite this aesthetic), either one value for or one color per variable. Pick \code{NA} to not set colors (in case you want to use them yourself in the aesthetics).}

\item{palette}{which color to make the plots defined with an RColorBrewer palette (\code{\link[RColorBrewer:ColorBrewer]{RColorBrewer::display.brewer.all()}}). You can only use \code{color} or \code{palette} parameter, not both.}

\item{both_axes}{whether to have the stacked axes on both sides (overrides alternate_axes and switch_axes)}

\item{alternate_axes}{whether to alternate the sides on which the stacked axes are plotted}

\item{switch_axes}{whether to switch the stacked axes. Not switching means the first plot in the lower left corner is always arranged like a regular ggplot with the y axis on the left and the x axis on the bottom (even if \code{alternate_axes = TRUE}). Setting \code{switch_axes = TRUE}, leads to the opposite, i.e. first plot in the lower corner has the variable axis on the other side (secondary in ggplot terms).}

\item{overlap}{fractional overlap between adjacent plots. The max of 1 means plots are perfectly overlaid. The min of 0 means there is no overlap. If providing multiple values, must be 1 less than the number of stacked plots (since it's describing the overlap/gap between adjacent plots). By default there is no overlap between plots}

\item{simplify_shared_axis}{whether to simplify the shared axis to only be on the last plot (+ first plot if a duplicate secondary axis is set)}

\item{shared_axis_size}{if simplify_shared_axes is true, this determines the size of the shared axis relative to the size of a single plot}

\item{template}{a template plot (ggplot object) to use for the stacked plots}

\item{add}{a list of ggplot component calls to add to specific panel plots, either by panel variable name (named list) or index (unnamed list)}

\item{debug}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} debug flag to print the stackplot tibble and gtable intermediates}

\item{prepared_stackplot}{a nested data frame, the output from \code{\link[=prepare_stackplot]{prepare_stackplot()}}}
}
\value{
\code{ggstackplot()} returns a ggplot with overlayed plot layers

\code{prepare_stackplot()} returns a tibble with all plot components

\code{assemble_stackplot()} returns a ggplot with overlayed plot layers
}
\description{
Use \code{ggstackplot()} to generate a stackplot. If you need more fine control, use \code{prepare_stackplot()} and \code{assemble_stackplot()} individually.
}
\details{
\code{ggstackplot()} stacks a ggplot template with the provided data and parameters. It returns a plot object generated by \code{\link[cowplot:plot_grid]{cowplot::plot_grid()}}).

\code{prepare_stackplot()} is usually not called directly but can be used to assemble the parts of a stackplot first and then look at them or edit them individually before combining them with \verb{assemble_stackplot()]}. Returns a nested data frame with all stacked variables (.var), their plot configuration, data, plot object, and theme object.

\code{assemble_stackplot()} is usually not called directly but can be used to manually combine a stackplot tibble (typically created by \code{prepare_stockplot()}). Returns a plot object generated by \code{\link[cowplot:plot_grid]{cowplot::plot_grid()}}).
}
\examples{

# 1 step stackplot (most common use)
mtcars |>
  ggstackplot(
    x = mpg,
    y = c(`weight [g]` = wt, qsec, drat, disp),
    palette = "Set1",
    overlap = c(1, 0, 0.3)
  )

# 2 step stackplot
mtcars |>
  prepare_stackplot(
    x = mpg,
    y = c(`weight [g]` = wt, qsec, drat, disp),
    palette = "Set1"
  ) |>
  assemble_stackplot(overlap = c(1, 0, 0.3))

}
