% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-spatial-xline.R
\docType{data}
\name{annotation_spatial_hline}
\alias{annotation_spatial_hline}
\alias{annotation_spatial_vline}
\alias{GeomSpatialXline}
\title{Projected horizontal and vertical lines}
\format{
An object of class \code{GeomSpatialXline} (inherits from \code{GeomHline}, \code{Geom}, \code{ggproto}, \code{gg}) of length 4.
}
\usage{
annotation_spatial_hline(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  ...,
  intercept = waiver(),
  limits = NULL,
  detail = 100,
  crs = NULL,
  na.rm = FALSE,
  show.legend = NA
)

annotation_spatial_vline(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  ...,
  intercept = waiver(),
  limits = NULL,
  detail = 100,
  crs = NULL,
  na.rm = FALSE,
  show.legend = NA
)

GeomSpatialXline
}
\arguments{
\item{mapping}{An aesthetic mapping created with \code{\link[ggplot2:aes]{ggplot2::aes()}}.}

\item{data}{A data frame or other object, coerced to a data.frame by \code{\link[ggplot2:fortify]{ggplot2::fortify()}}.}

\item{stat}{Statistical transformation to use on this layer. See \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{...}{Passed to the combined stat/geom as parameters or fixed aesthetics.}

\item{intercept}{The x or y value that should be constant in the given
\code{crs}. Can also be passed as an aesthetic through \code{data} and \code{mapping}.}

\item{limits}{Use \code{NULL} to guess the minimum and maximum x or y value in
the non-constant dimension, or specify a vector of length 2 to specify
manually.}

\item{detail}{The number of points that should be used when converting the
line into segments.}

\item{crs}{The crs of the x and y aesthetics, or NULL to use default lon/lat
crs (with a message).}

\item{na.rm}{Should missing aesthetic values be removed?}

\item{show.legend}{See \code{\link[ggplot2:layer]{ggplot2::layer()}}.}
}
\description{
Projected horizontal and vertical lines
}
\examples{
cities <- data.frame(
  x = c(-63.58595, 116.41214, 0),
  y = c(44.64862, 40.19063, 89.9),
  city = c("Halifax", "Beijing", "North Pole")
)

p <- ggplot(cities, aes(x, y, label = city)) +
  geom_spatial_point(crs = 4326) +
  # view of the north pole
  coord_sf(crs = 3995)

p +
  # longitude lines
  annotation_spatial_vline(
    intercept = seq(-180, 180, by = 10),
    crs = 4326
  ) +
  # latitude lines
  annotation_spatial_hline(
    intercept = seq(0, 90, by = 10),
    crs = 4326
  )

}
\keyword{datasets}
