% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggside-ggproto.r, R/sideFacet--utils.R,
%   R/sideFacet-Grid.R, R/sideFacet-Null.R, R/sideFacet-Wrap.R
\docType{data}
\name{ggside-ggproto-facets}
\alias{ggside-ggproto-facets}
\alias{as_ggsideFacet}
\alias{check_scales_collapse}
\alias{sidePanelLayout}
\alias{prep_map_data}
\alias{FacetSideGrid}
\alias{FacetSideNull}
\alias{FacetSideWrap}
\title{Extending base ggproto classes for ggside}
\usage{
as_ggsideFacet(facet, ggside)

check_scales_collapse(data, params)

sidePanelLayout(layout, ggside)

prep_map_data(layout, data)
}
\arguments{
\item{facet}{Facet ggproto Object to replace}

\item{ggside}{ggside object to update}

\item{data}{data passed through ggproto object}

\item{params}{parameters passed through ggproto object}

\item{layout}{layout computed by inherited ggproto Facet compute_layout method}
}
\value{
ggproto object that can be added to a ggplot object
}
\description{
S3 class that converts old Facet into one that
is compatible with ggside. Can also update
ggside on the object. Typically, the new ggproto
will inherit from the object being replaced.

\code{check_scales_collapse} is a helper function that
is meant to be called after the inherited Facet's
compute_layout method

\code{sidePanelLayout} is a helper function that
is meant to be called after the inherited Facet's
compute_layout method and after \code{check_scales_collapse}

\code{prep_map_data} is a utility function to help modify
the \code{data} and \code{layout} variables of the Facet's
\verb{$map_data} method. This will be sure to include the
column \code{PANEL_TYPE} that will assist where data should
map to. Please be sure to join against this column as well.
}
\section{Extended Facets}{


The following is a list \link{ggplot2} facets that are
available to use by ggside base.

\itemize{
\item \link[ggplot2]{FacetNull} -> FacetSideNull
\item \link[ggplot2]{FacetGrid} -> FacetSideGrid
\item \link[ggplot2]{FacetWrap} -> FacetSideWrap
}
}

\keyword{datasets}
