% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal-doc.r, R/scale-shadow.r
\name{scale_identity}
\alias{scale_shadowcolour_identity}
\title{Use values without scaling}
\usage{
scale_shadowcolour_identity(..., guide = "none", aesthetics = "shadowcolour")
}
\arguments{
\item{...}{Other arguments passed on to [discrete_scale()] or
[continuous_scale()]}

\item{guide}{Guide to use for this scale. Defaults to `"none"`.}

\item{aesthetics}{Character string or vector of character strings listing the
name(s) of the aesthetic(s) that this scale works with. This can be useful, for
example, to apply colour settings to the `colour` and `fill` aesthetics at the
same time, via `aesthetics = c("colour", "fill")`.}
}
\value{
a scale object to add to a plot.
}
\description{
Use this set of scales when your data has already been scaled, i.e. it
already represents aesthetic values that ggplot2 can handle directly.
These scales will not produce a legend unless you also supply the `breaks`,
`labels`, and type of `guide` you want.
}
\details{
The functions `scale_colour_identity()`, `scale_fill_identity()`, `scale_size_identity()`,
etc. work on the aesthetics specified in the scale name: `colour`, `fill`, `size`,
etc. However, the functions `scale_colour_identity()` and `scale_fill_identity()` also
have an optional `aesthetics` argument that can be used to define both `colour` and
`fill` aesthetic mappings via a single function call. The functions
`scale_discrete_identity()` and `scale_continuous_identity()` are generic scales that
can work with any aesthetic or set of aesthetics provided via the `aesthetics`
argument.
}
\examples{
library( ggplot2 )
p <- ggplot(mtcars, aes(wt, mpg, shadowcolor='red'))
p + geom_shadowpoint() + scale_shadowcolour_identity()


}
