% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggseqmtplot.R
\name{ggseqmtplot}
\alias{ggseqmtplot}
\title{Mean time plot}
\usage{
ggseqmtplot(
  seqdata,
  no.n = FALSE,
  group = NULL,
  weighted = TRUE,
  with.missing = FALSE,
  border = FALSE,
  error.bar = NULL,
  error.caption = TRUE,
  facet_scale = "fixed",
  facet_ncol = NULL,
  facet_nrow = NULL
)
}
\arguments{
\item{seqdata}{State sequence object (class \code{stslist}) created with the \code{\link[TraMineR:seqdef]{TraMineR::seqdef}} function.}

\item{no.n}{specifies if number of (weighted) sequences is shown
(default is \code{TRUE})}

\item{group}{A vector of the same length as the sequence data indicating group membership. When not NULL, a distinct plot is generated for each level of group.}

\item{weighted}{Controls if weights (specified in \code{\link[TraMineR:seqdef]{TraMineR::seqdef}}) should be used. Default is \code{TRUE}, i.e. if available weights are used}

\item{with.missing}{Specifies if missing states should be considered when
computing the state distributions (default is \code{FALSE}).}

\item{border}{if \code{TRUE} bars are plotted with black outline; default is \code{FALSE} (also accepts \code{NULL})}

\item{error.bar}{allows to add error bars either using the standard
deviation \code{"SD"} or the standard error \code{"SE"}; default plot is
without error bars}

\item{error.caption}{a caption is added if error bars are displayed; this
default behavior can be turned off by setting the argument to  \code{"FALSE"}}

\item{facet_scale}{Specifies if y-scale in faceted plot should be
\code{"fixed"} (default) or \code{"free_y"}}

\item{facet_ncol}{Number of columns in faceted (i.e. grouped) plot}

\item{facet_nrow}{Number of rows in faceted (i.e. grouped) plot}
}
\value{
A mean time plot created by using \code{\link[ggplot2]{ggplot2}}.
If stored as object the resulting list object (of class gg and ggplot) also
contains the data used for rendering the plot
}
\description{
Function for rendering plot displaying the mean time spent in each state of
a state sequence object using \code{\link[ggplot2]{ggplot2}}
\insertCite{wickham2016}{ggseqplot} instead of base R's
\code{\link[base]{plot}} function that is used by
\code{\link[TraMineR:seqplot]{TraMineR::seqplot}}
\insertCite{gabadinho2011}{ggseqplot}.
}
\details{
The information on time spent in different states is obtained by an
internal call of \code{\link[TraMineR:seqmeant]{TraMineR::seqmeant}}. This
requires that the input data (\code{seqdata}) are stored as state sequence
object (class \code{stslist}) created with the
\code{\link[TraMineR:seqdef]{TraMineR::seqdef}} function. The resulting
output then is prepared to be plotted with
\code{\link[ggplot2:geom_bar]{ggplot2::geom_bar}}. The data and
specifications used for rendering the plot can be obtained by storing the
plot as an object. The appearance of the plot can be adjusted just like with
every other ggplot (e.g., by changing the theme or the scale using \code{+}
and the respective functions).
}
\examples{
# Use examples from TraMineR & load ggplot for fine-tuning the plot
library(TraMineR)
library(ggplot2)

# actcal data set
data(actcal)

# We use only a sample of 300 cases
set.seed(1)
actcal <- actcal[sample(nrow(actcal), 300), ]
actcal.lab <- c("> 37 hours", "19-36 hours", "1-18 hours", "no work")
actcal.seq <- seqdef(actcal, 13:24, labels = actcal.lab)

# modal state sequence plot; grouped by sex
# with TraMineR::seqplot
seqmtplot(actcal.seq, group = actcal$sex)
# with ggseqplot
ggseqmtplot(actcal.seq, group = actcal$sex)
# with ggseqplot using additional arguments and some adjustments
ggseqmtplot(actcal.seq, no.n = TRUE, error.bar = "SE") +
 coord_flip() +
 theme(axis.text.y=element_blank(),
       axis.ticks.y = element_blank(),
       panel.grid.major.y = element_blank(),
       legend.position = "top")

}
\references{
\insertAllCited{}
}
\author{
Marcel Raab
}
