% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-cosmic.R
\name{scale_color_cosmic}
\alias{scale_color_cosmic}
\alias{scale_colour_cosmic}
\alias{scale_fill_cosmic}
\title{COSMIC Color Scales}
\usage{
scale_color_cosmic(
  palette = c("hallmarks_light", "hallmarks_dark", "signature_substitutions"),
  alpha = 1,
  ...
)

scale_colour_cosmic(
  palette = c("hallmarks_light", "hallmarks_dark", "signature_substitutions"),
  alpha = 1,
  ...
)

scale_fill_cosmic(
  palette = c("hallmarks_light", "hallmarks_dark", "signature_substitutions"),
  alpha = 1,
  ...
)
}
\arguments{
\item{palette}{Palette type. Currently there are three available options:
\code{"signature_substitutions"} (6-color palette),
\code{"hallmarks_light"} (10-color palette), and \code{"hallmarks_dark"}
(10-color palette). The \code{"hallmarks_light"} option is from
\href{https://pubmed.ncbi.nlm.nih.gov/21376230/}{Hanahan and Weinberg (2011)}.}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices]{rgb}} for details.}

\item{...}{additional parameters for \code{\link[ggplot2]{discrete_scale}}}
}
\description{
See \code{\link{pal_cosmic}} for details.
}
\examples{
library("ggplot2")
data("diamonds")

ggplot(
  subset(diamonds, carat >= 2.2),
  aes(x = table, y = price, colour = cut)
) +
  geom_point(alpha = 0.7) +
  geom_smooth(method = "loess", alpha = 0.1, size = 1, span = 1) +
  theme_bw() +
  scale_color_cosmic()

ggplot(
  subset(diamonds, carat > 2.2 & depth > 55 & depth < 70),
  aes(x = depth, fill = cut)
) +
  geom_histogram(colour = "black", binwidth = 1, position = "dodge") +
  theme_bw() +
  scale_fill_cosmic()
}
\author{
Joshua H. Cook <\email{joshuacook0023@gmail.com}> |
<\href{https://github.com/jhrcook}{GitHub/jhrcook}>
}
