% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08.rickandmorty.R
\name{scale_color_rickandmorty}
\alias{scale_color_rickandmorty}
\alias{scale_colour_rickandmorty}
\alias{scale_fill_rickandmorty}
\title{Rick and Morty Color Scales}
\usage{
scale_color_rickandmorty(palette = c("schwifty"), alpha = 1, ...)

scale_colour_rickandmorty(palette = c("schwifty"), alpha = 1, ...)

scale_fill_rickandmorty(palette = c("schwifty"), alpha = 1, ...)
}
\arguments{
\item{palette}{Palette type.
Currently there is one available option: \code{"schwifty"}
(12-color palette).}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices]{rgb}} for details.}

\item{...}{additional parameters for \code{\link[ggplot2]{discrete_scale}}}
}
\description{
See \code{\link{pal_rickandmorty}} for details.
}
\examples{
library("ggplot2")
data("diamonds")

ggplot(subset(diamonds, carat >= 2.2),
       aes(x = table, y = price, colour = cut)) +
  geom_point(alpha = 0.7) +
  geom_smooth(alpha = 0.1, size = 1, span = 1) +
  theme_bw() + scale_color_rickandmorty()

ggplot(subset(diamonds, carat > 2.2 & depth > 55 & depth < 70),
       aes(x = depth, fill = cut)) +
  geom_histogram(colour = "black", binwidth = 1, position = "dodge") +
  theme_bw() + scale_fill_rickandmorty()
}
\author{
Nan Xiao <\email{nanx@uchicago.edu}> |
<\href{http://nanx.me}{http://nanx.me}>
}

