% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_node_arc_bar.R
\name{geom_node_arc_bar}
\alias{geom_node_arc_bar}
\title{Show nodes as thick arcs}
\usage{
geom_node_arc_bar(
  mapping = NULL,
  data = NULL,
  position = "identity",
  show.legend = NA,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}
or \code{\link[ggplot2:aes_]{ggplot2::aes_()}}. By default x and y are mapped to x0 and y0 in
the node data.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
This geom is equivalent in functionality to \code{\link[ggforce:geom_arc_bar]{ggforce::geom_arc_bar()}}
and allows for plotting of nodes as arcs with an inner and outer radius
scaled by the coordinate system. Its main use is currently in sunburst plots
as created with circular partition layouts
}
\section{Aesthetics}{

\code{geom_node_point} understand the following aesthetics. Bold aesthetics are
automatically set, but can be overridden.
\itemize{
\item \strong{x0}
\item \strong{y0}
\item \strong{r0}
\item \strong{r}
\item \strong{start}
\item \strong{end}
\item alpha
\item colour
\item fill
\item shape
\item size
\item stroke
\item filter
}
}

\examples{
require(tidygraph)
gr <- tbl_graph(flare$vertices, flare$edges)
ggraph(gr, 'partition', circular = TRUE, weight = size) +
  geom_node_arc_bar()
}
\seealso{
Other geom_node_*: 
\code{\link{geom_node_circle}()},
\code{\link{geom_node_point}()},
\code{\link{geom_node_range}()},
\code{\link{geom_node_text}()},
\code{\link{geom_node_tile}()},
\code{\link{geom_node_voronoi}()}
}
\author{
Thomas Lin Pedersen
}
\concept{geom_node_*}
