% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_igraph.R
\name{layout_tbl_graph_igraph}
\alias{layout_tbl_graph_igraph}
\title{Use igraph layout algorithms for layout_tbl_graph}
\usage{
layout_tbl_graph_igraph(graph, algorithm, circular, offset = pi/2,
  use.dummy = FALSE, ...)
}
\arguments{
\item{graph}{A \code{tbl_graph} object.}

\item{algorithm}{The type of layout algorithm to apply. See \emph{Details} or
\code{\link[igraph:layout_]{igraph::layout_()}} for links to the layouts supplied by igraph.}

\item{circular}{Logical. Should the layout be transformed to a circular
representation. Defaults to \code{FALSE}. Only applicable to
\code{algorithm = 'tree'} and \code{algorithm = 'sugiyama'}.}

\item{offset}{If \code{circular = TRUE}, where should it begin. Defaults to
\code{pi/2} which is equivalent to 12 o'clock.}

\item{use.dummy}{Logical. In the case of \code{algorithm = 'sugiyama'} should the
dummy-infused graph be used rather than the original. Defaults to
\code{FALSE}.}

\item{...}{Arguments passed on to the respective layout functions}
}
\value{
A data.frame with the columns \code{x}, \code{y}, \code{circular} as
well as any information stored as node variables in the tbl_graph object.
}
\description{
This layout function makes it easy to apply one of the layout algorithms
supplied in igraph when plotting with ggraph. Layout names are auto completed
so there is no need to write \code{layout_with_graphopt} or
\code{layout_as_tree}, just \code{graphopt} and \code{tree} (though the
former will also work if you want to be super explicit). Circular layout is
only supported for tree-like layout (\code{tree} and \code{sugiyama}) and
will throw an error when applied to other layouts.
}
\details{
igraph provides a huge amount of possible layouts. They are all briefly
described below:

\strong{Hierarchical layouts}

\describe{
\item{\code{tree}}{Uses the \emph{Reingold-Tilford} algorithm to place the
nodes below their parent with the parent centered above its children. See
\code{\link[igraph:as_tree]{igraph::as_tree()}}}
\item{\code{sugiyama}}{Designed for directed acyclic graphs (that is,
hierarchies where multiple parents are allowed) it minimizes the number of
crossing edges. See \code{\link[igraph:with_sugiyama]{igraph::with_sugiyama()}}}
}

\strong{Standard layouts}

\describe{
\item{\code{bipartite}}{Minimize edge-crossings in a simple two-row (or
column) layout for bipartite graphs. See \code{\link[igraph:as_bipartite]{igraph::as_bipartite()}}}
\item{\code{star}}{Place one node in the center and the rest equidistantly
around it. See \code{\link[igraph:as_star]{igraph::as_star()}}}
\item{\code{circle}}{Place nodes in a circle in the order of their index.
Consider using \code{\link[=layout_tbl_graph_linear]{layout_tbl_graph_linear()}} with \code{circular=TRUE}
for more control. See \code{\link[igraph:in_circle]{igraph::in_circle()}}}
\item{\code{nicely}}{Tries to pick an appropriate layout. See
\code{\link[igraph:nicely]{igraph::nicely()}} for a description of the simple decision tree
it uses}
\item{\code{dh}}{Uses \emph{Davidson and Harels} simulated annealing
algorithm to place nodes. See \code{\link[igraph:with_dh]{igraph::with_dh()}}}
\item{\code{gem}}{Place nodes on the plane using the GEM force-directed
layout algorithm. See \code{\link[igraph:with_gem]{igraph::with_gem()}}}
\item{\code{graphopt}}{Uses the Graphopt algorithm based on alternating
attraction and repulsion to place nodes. See
\code{\link[igraph:with_graphopt]{igraph::with_graphopt()}}}
\item{\code{grid}}{Place nodes on a rectangular grid. See
\code{\link[igraph:on_grid]{igraph::on_grid()}}}
\item{\code{mds}}{Perform a multidimensional scaling of nodes using either
the shortest path or a user supplied distance. See
\code{\link[igraph:with_mds]{igraph::with_mds()}}}
\item{\code{sphere}}{Place nodes uniformly on a sphere - less relevant for
2D visualizations of networks. See \code{\link[igraph:on_sphere]{igraph::on_sphere()}}}
\item{\code{randomly}}{Places nodes uniformly random. See
\code{\link[igraph:randomly]{igraph::randomly()}}}
\item{\code{fr}}{Places nodes according to the force-directed algorithm of
Fruchterman and Reingold. See \code{\link[igraph:with_fr]{igraph::with_fr()}}}
\item{\code{kk}}{Uses the spring-based algorithm by Kamada and Kawai to
place nodes. See \code{\link[igraph:with_kk]{igraph::with_kk()}}}
\item{\code{drl}}{Uses the force directed algorithm from the DrL toolbox to
place nodes. See \code{\link[igraph:with_drl]{igraph::with_drl()}}}
\item{\code{lgl}}{Uses the algorithm from Large Graph Layout to place
nodes. See \code{\link[igraph:with_lgl]{igraph::with_lgl()}}}
}
}
\note{
This function is not intended to be used directly but by setting
\code{layout = 'igraph'} in \code{\link[=create_layout]{create_layout()}}
}
\seealso{
Other layout_tbl_graph_*: \code{\link{layout_tbl_graph_auto}},
  \code{\link{layout_tbl_graph_backbone}},
  \code{\link{layout_tbl_graph_centrality}},
  \code{\link{layout_tbl_graph_circlepack}},
  \code{\link{layout_tbl_graph_dendrogram}},
  \code{\link{layout_tbl_graph_eigen}},
  \code{\link{layout_tbl_graph_fabric}},
  \code{\link{layout_tbl_graph_focus}},
  \code{\link{layout_tbl_graph_hive}},
  \code{\link{layout_tbl_graph_linear}},
  \code{\link{layout_tbl_graph_manual}},
  \code{\link{layout_tbl_graph_matrix}},
  \code{\link{layout_tbl_graph_partition}},
  \code{\link{layout_tbl_graph_pmds}},
  \code{\link{layout_tbl_graph_stress}},
  \code{\link{layout_tbl_graph_treemap}},
  \code{\link{layout_tbl_graph_unrooted}}
}
\concept{layout_tbl_graph_*}
