% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-nudge-center.R
\name{position_nudge_center}
\alias{position_nudge_center}
\alias{position_nudge_centre}
\alias{position_nudge_keep}
\title{Nudge labels away from a central point}
\usage{
position_nudge_center(
  x = 0,
  y = 0,
  center_x = NULL,
  center_y = NULL,
  direction = NULL,
  obey_grouping = NULL,
  kept.origin = "original"
)

position_nudge_centre(
  x = 0,
  y = 0,
  center_x = NULL,
  center_y = NULL,
  direction = NULL,
  obey_grouping = NULL,
  kept.origin = "original"
)

position_nudge_keep(x = 0, y = 0)
}
\arguments{
\item{x, y}{Amount of vertical and horizontal distance to move. A numeric
vector of length 1, or of the same length as rows there are in `data`,}

\item{center_x, center_y}{The coordinates of the virtual origin out from which
nudging radiates or splits in opposite directions. A numeric vector of
length 1 or of the same length as rows there are in `data`, or a function
returning either of these vectors computed from the variables in data
mapped to `x` or `y`, respectively.}

\item{direction}{One of "none", "radial", or "split". A value of "none"
replicates the behavior of [ggplot2::position_nudge]. Which of these three
values is the default depends on the values passed to the other parameters.}

\item{obey_grouping}{A logical flag indicating whether to obey or not groupings
of the observations. By default, grouping is obeyed when both of the
variables mapped to _x_ and _y_ are continuous numeric and ignored
otherwise.}

\item{kept.origin}{One of "original" or "none".}
}
\value{
A \code{"Position"} object.
}
\description{
`position_nudge_center()` is generally useful for adjusting the position of
labels or text, both on a discrete or continuous scale. In contrast to
[ggplot2::position_nudge], `position_nudge_center()` returns in `data` both
the original coordinates and the nudged coordinates.
}
\details{
This position function is backwards compatible with [ggplot2::position_nudge]
but extends it by adding support for nudging that varies across the plotting
region, either in opposite directions or radially from a virtual _center
point_.

The wrapper `position_nudge_keep()` with exactly the same signature and
behaviour as [ggplot2::position_nudge] provides an easier to remember name
when the desire is only to have access to both the original and nudged
coordinates.

Positive values as arguments to `x` and `y` are added to the
  original position along either axis. If no arguments are passed to
  `center_x`, `center_y` or `direction`, the nudging is applied as is, as is
  the case if `direction = "none"`. If non-`NULL` arguments are passed to
  both `center_x` and `center_y`, `direction = "radial"` is assumed. In this
  case, if `x` and/or `y` positive nudging is applied radially outwards from
  the center, while if negative, inwards towards the center. When a
  non-`NULL` argument is passed only to one of `center_x` or `center_y`,
  `direction = "split"` is assumed. In this case when the initial location of
  the point is to the left of `center_x`, `-x` is used instead of `x` for
  nudging, and when the initial location of the point is to the below of
  `center_y`, `-y` is used instead of `y` for nudging. If non-`NULL` arguments
  are passed to both `center_x` and `center_y`, and `direction` is passed
  `"split"` as argument, then the split as described above is applied to
  both _x_ and _y_ coordinates.
}
\note{
Some situations are handled as special cases. When `direction =
  "split"` or `direction = "radial"`, observations at exactly the _center_
  are nudged using `x` and `y` unchanged. When `direction = "split"`, and
  both `center_x` and `center_y` have been supplied, segments are drawn at
  eight different possible angles. When segments are exactly horizontal or
  vertical they would be shorter than when drawn at the other four angles, in
  which case `x` or `y` are extended to ensure these segments are of the same
  lengths as those at other angles.

  This position is most useful when labeling points forming a cloud or
  along vertical or horizontal lines or "divides".
}
\examples{
df <- data.frame(
  x = c(1,3,2,5,4,2.5),
  y = c("abc","cd","d","c","bcd","a")
)

# Plain nudging, same as with ggplot2::position_nudge()

ggplot(df, aes(x, y, label = y)) +
  geom_point() +
  geom_text(hjust = 0, vjust = 0,
            position = position_nudge(x = 0.05, y = 0.07)
  )

ggplot(df, aes(x, y, label = y)) +
  geom_point() +
  geom_text(hjust = 0, vjust = 0,
            position = position_nudge_center(x = 0.05, y = 0.07)
  )

# "split" nudging

ggplot(df, aes(x, y)) +
  geom_point() +
  geom_text(aes(label = y),
            hjust = "outward", vjust = "outward",
            position = position_nudge_center(x = 0.05,
                                             y = 0.07,
                                             direction = "split"))

ggplot(df, aes(x, y)) +
  geom_point() +
  geom_text(aes(label = y),
            hjust = "outward",
            position = position_nudge_center(x = 0.08,
                                             direction = "split"))

ggplot(df, aes(x, y)) +
  geom_point() +
  geom_text(aes(label = y),
            vjust = "outward",
            position = position_nudge_center(y = 0.1,
                                             direction = "split"))

ggplot(df, aes(x, y)) +
  geom_point() +
  geom_text(aes(label = y),
            vjust = "outward", hjust = "outward",
            position = position_nudge_center(x = 0.06,
                                             y = 0.08,
                                             center_y = 2,
                                             center_x = 1.5,
                                             direction = "split"))

ggplot(df, aes(x, y)) +
  geom_point() +
  geom_text(aes(label = y),
            vjust = "outward", hjust = "outward",
            position = position_nudge_center(x = 0.06,
                                             y = 0.08,
                                             center_y = 2))

ggplot(df, aes(x, y)) +
  geom_point() +
  geom_text(aes(label = y),
            vjust = "outward", hjust = "outward",
            position = position_nudge_center(x = 0.1,
                                             center_x = 2.5))

ggplot(df, aes(x, y)) +
  geom_point() +
  geom_text(aes(label = y),
            vjust = "outward", hjust = "outward",
            position = position_nudge_center(x = 0.06,
                                             y = 0.08,
                                             center_x = median,
                                             center_y = median,
                                             direction = "split"))

# "Radial" nudging

ggplot(df, aes(x, y)) +
  geom_point() +
  geom_text(aes(label = y),
            vjust = "outward", hjust = "outward",
            position = position_nudge_center(x = 0.1,
                                             y = 0.2,
                                             direction = "radial"))

ggplot(df, aes(x, y)) +
  geom_point() +
  geom_text(aes(label = y),
            vjust = "inward", hjust = "inward",
            position = position_nudge_center(x = -0.1,
                                             y = -0.1,
                                             direction = "radial"))

df <- data.frame(
  x = -10:10,
  z = (-10:10)^2,
  y = letters[1:21],
  group = rep(c("a", "b"), rep(c(11, 10)))
)

ggplot(df, aes(x, z)) +
  geom_point() +
  geom_line() +
  geom_text(aes(label = y),
            vjust = "inward", hjust = "inward",
            position = position_nudge_center(x = -0.9,
                                             y = -2.7,
                                             center_x = mean,
                                             center_y = max))

ggplot(df, aes(x, z)) +
  geom_point() +
  geom_line() +
  geom_text(aes(label = y),
            vjust = "outward", hjust = "outward",
            position = position_nudge_center(x = 0.9,
                                             y = 2.7,
                                             center_x = mean,
                                             center_y = max))

above_max <- function(x) {1.2 * max(x)}
ggplot(df, aes(x, z)) +
  geom_point() +
  geom_line() +
  geom_text(aes(label = y),
            vjust = "inward", hjust = "inward",
            position = position_nudge_center(x = -1.2,
                                             y = -3,
                                             center_x = mean,
                                             center_y = above_max))

ggplot(df, aes(x, z, color = group)) +
  geom_point() +
  geom_line(color = "black", linetype = "dotted") +
  geom_text(aes(label = y),
            vjust = "inward", hjust = "inward",
            position = position_nudge_center(x = -0.9,
                                             y = -2.7,
                                             center_x = mean,
                                             center_y = max))

ggplot(df, aes(x, z, color = group)) +
  geom_point() +
  geom_line(color = "black", linetype = "dotted") +
  geom_text(aes(label = y),
            vjust = "inward", hjust = "inward",
            position = position_nudge_center(x = -0.9,
                                             y = -2.7,
                                             center_x = mean,
                                             center_y = max,
                                             obey_grouping = FALSE))

}
\seealso{
[ggplot2::position_nudge()], [ggrepel::position_nudge_repel()].

Other position adjustments: 
\code{\link{position_dodgenudge}()},
\code{\link{position_jitternudge}()},
\code{\link{position_nudge_line}()},
\code{\link{position_nudge_to}()},
\code{\link{position_stacknudge}()}
}
\concept{position adjustments}
