% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_daa.R
\name{pathway_daa}
\alias{pathway_daa}
\title{Predictional functional patwhay differential abundance (DA)}
\usage{
pathway_daa(
  abundance,
  metadata,
  group,
  daa_method = "ALDEx2",
  select = NULL,
  p.adjust = "BH",
  reference = NULL
)
}
\arguments{
\item{abundance}{a data frame containing predicted functional pathway abundance, with pathways/features as rows and samples as columns. The column names of abundance should match the sample names in metadata. Pathway abundance values should be counts}

\item{metadata}{a tibble containing samples information}

\item{group}{a character specifying the group name for differential abundance analysis}

\item{daa_method}{a character specifying the method for differential abundance analysis, choices are:
- "ALDEx2": ANOVA-Like Differential Expression tool for high throughput sequencing data
- "DESeq2": Differential expression analysis based on the negative binomial distribution using DESeq2
- "edgeR": Exact test for differences between two groups of negative-binomially distributed counts using edgeR
- "limma voom": Limma-voom framework for the analysis of RNA-seq data
- "metagenomeSeq": Fit logistic regression models to test for differential abundance between groups using metagenomeSeq
- "LinDA": Linear models for differential abundance analysis of microbiome compositional data
- "Maaslin2": Multivariate Association with Linear Models (MaAsLin2) for differential abundance analysis
- "Lefse": Linear discriminant analysis (LDA) effect size algorithm for high-dimensional microbiome data}

\item{select}{a vector containing sample names for analysis, if NULL all samples are included. This parameter can be used to specify which samples are included in the differential abundance analysis. Default is NULL.}

\item{p.adjust}{a character specifying the method for p-value adjustment, choices are:
- "BH": Benjamini-Hochberg correction
- "holm": Holm's correction
- "bonferroni": Bonferroni correction
- "hochberg": Hochberg's correction
- "fdr": False discovery rate correction
- "none": No p-value adjustment.}

\item{reference}{a character specifying the reference group level, required for several differential abundance analysis methods such as LinDA, limme voom and Maaslin2. This parameter is used to specify the reference group when there are more than two groups. Default is NULL.}
}
\value{
a data frame containing the differential abundance analysis results.
}
\description{
Predictional functional patwhay differential abundance (DA)
}
\examples{
\donttest{
library(ggpicrust2)
library(MicrobiomeStat)
library(tibble)
library(magrittr)
abundance <- data.frame(sample1 = c(10, 20, 30),
sample2 = c(20, 30, 40),
sample3 = c(30, 40, 50),
row.names = c("pathway1", "pathway2", "pathway3"))

metadata <- tibble::tibble(sample = paste0("sample", 1:3),
group = c("control", "control", "treatment"))

#Run pathway_daa function
result <- pathway_daa(abundance = abundance, metadata = metadata, group = "group",
daa_method = "LinDA")

data(metacyc_abundance)
data(metadata)
daa_results_df <- pathway_daa(metacyc_abundance \%>\%
column_to_rownames("pathway"), metadata, "Environment", daa_method = "LinDA")
}
}
