% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-pattern-linetype.R
\name{scale_pattern_linetype}
\alias{scale_pattern_linetype}
\alias{scale_pattern_linetype_continuous}
\alias{scale_pattern_linetype_discrete}
\title{Scale for line patterns}
\usage{
scale_pattern_linetype(..., na.value = "blank")

scale_pattern_linetype_continuous(...)

scale_pattern_linetype_discrete(..., na.value = "blank")
}
\arguments{
\item{...}{see \code{ggplot2::scale_linetype} for more information}

\item{na.value}{The linetype to use for \code{NA} values.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Scale} object.
}
\description{
Default line types based on a set supplied by Richard Pearson,
University of Manchester. Continuous values can not be mapped to
line types.
}
\examples{
  if (require("ggplot2")) {
    # 'stripe' pattern example
    df <- data.frame(level = c("a", "b", "c", 'd'), outcome = c(2.3, 1.9, 3.2, 1))
    gg <- ggplot(df) +
      geom_col_pattern(
        aes(level, outcome, pattern_fill = level, pattern_linetype = level),
        pattern_density = 0.6,
        pattern_size = 1.5,
        pattern = 'stripe',
        fill    = 'white',
        colour  = 'black',
        size = 1.5
      ) +
      theme_bw(18) +
      theme(legend.position = 'none') +
      scale_pattern_linetype() +
      labs(
        title    = "ggpattern::geom_col_pattern()",
        subtitle = "pattern = 'stripe'"
      )
    plot(gg)
  }
}
