% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stamenmap.R
\name{get_stamenmap}
\alias{get_stamenmap}
\alias{get_stamen_tile_download_fail_log}
\alias{retry_stamen_map_download}
\title{Get a Stamen Map}
\usage{
get_stamenmap(
  bbox = c(left = -95.80204, bottom = 29.38048, right = -94.92313, top = 30.14344),
  zoom = 10,
  maptype = c("terrain", "terrain-background", "terrain-labels", "terrain-lines",
    "toner", "toner-2010", "toner-2011", "toner-background", "toner-hybrid",
    "toner-labels", "toner-lines", "toner-lite", "watercolor"),
  crop = TRUE,
  messaging = FALSE,
  urlonly = FALSE,
  color = c("color", "bw"),
  force = FALSE,
  where = tempdir(),
  https = FALSE,
  ...
)

get_stamen_tile_download_fail_log()

retry_stamen_map_download()
}
\arguments{
\item{bbox}{a bounding box in the format c(lowerleftlon, lowerleftlat,
upperrightlon, upperrightlat).}

\item{zoom}{a zoom level}

\item{maptype}{terrain, terrain-background, terrain-labels, terrain-lines,
toner, toner-2010, toner-2011, toner-background, toner-hybrid,
toner-labels, toner-lines, toner-lite, or watercolor.}

\item{crop}{crop raw map tiles to specified bounding box. if FALSE, the
resulting map will more than cover the bounding box specified.}

\item{messaging}{turn messaging on/off}

\item{urlonly}{return url only}

\item{color}{color or black-and-white (use force = TRUE if you've already
downloaded the images)}

\item{force}{if the map is on file, should a new map be looked up?}

\item{where}{where should the file drawer be located (without terminating
"/")}

\item{https}{if TRUE, queries an https endpoint so that web traffic between
you and the tile server is ecrypted using SSL.}

\item{...}{...}
}
\value{
a ggmap object (a classed raster object with a bounding box
attribute)
}
\description{
\code{\link[=get_stamenmap]{get_stamenmap()}} accesses a tile server for Stamen Maps and
downloads/stitches map tiles/formats a map image. Note that Stamen maps don't
cover the entire world.
}
\seealso{
\code{\link[=ggmap]{ggmap()}}
}
