% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LonLat2XY.R
\name{LonLat2XY}
\alias{LonLat2XY}
\title{Convert a lon/lat coordinate to a tile coordinate}
\usage{
LonLat2XY(lon_deg, lat_deg, zoom, xpix = 256, ypix = 256)
}
\arguments{
\item{lon_deg}{longitude in degrees}

\item{lat_deg}{latitude in degrees}

\item{zoom}{zoom}

\item{xpix}{width of tile in pixels}

\item{ypix}{length of tile in pixels}
}
\value{
a data frame with columns X, Y, x, y
}
\description{
Convert a lon/lat coordinate to a tile coordinate for a given zoom.  Decimal
tile coordinates (x, y) are reported.
}
\examples{


\dontrun{
gc <- geocode('baylor university')
LonLat2XY(gc$lon, gc$lat, 10)

}

}
\seealso{
\url{https://wiki.openstreetmap.org/wiki/Slippy_map_tilenames}
}
\author{
David Kahle \email{david@kahle.io}, based on
\code{\link[RgoogleMaps:LatLon2XY]{RgoogleMaps::LatLon2XY()}} by Markus Loecher of Sense Networks
\email{markus@sensenetworks.com}
}
