% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_coverage.R
\name{geom_coverage}
\alias{geom_coverage}
\title{Layer for Coverage Plot.}
\usage{
geom_coverage(
  data,
  mapping = NULL,
  color = NULL,
  rect.color = NA,
  facet.key = "Type",
  facet.order = NULL,
  facet.color = NULL,
  group.key = "Group",
  range.size = 3,
  range.position = c("in", "out"),
  mark.region = NULL,
  mark.color = "grey",
  mark.alpha = 0.5,
  show.mark.label = TRUE,
  mark.label.size = 4
)
}
\arguments{
\item{data}{Track prepared by \code{\link{FormatTrack}}.}

\item{mapping}{Set of aesthetic mappings created by \code{aes} or \code{aes_}. Default: NULL.}

\item{color}{Track color. Default: NULL (select automatically).}

\item{rect.color}{The color of every bin. Default: NA.}

\item{facet.key}{Sample type key to create coverage plot. Default: Type.}

\item{facet.order}{The order of coverage plot. Default: NULL.}

\item{facet.color}{The color of sample text. Default: NULL (select automatically).}

\item{group.key}{Group of samples. Default: NULL.}

\item{range.size}{The label size of range text, used when \code{range.position} is in. Default: 3.}

\item{range.position}{The position of y axis range, chosen from in (move y axis in the plot) and
out (normal y axis). Default: in.}

\item{mark.region}{Mark region on the plot. Default: NULL.}

\item{mark.color}{The color of marked region. Default: "grey".}

\item{mark.alpha}{The alpha of marked region. Default: 0.5.}

\item{show.mark.label}{Logical value, whether to show mark label (use label column in \code{mark.region}). Default: TRUE.}

\item{mark.label.size}{The label size of mark label. Default: 4.}
}
\value{
Layers of ggplot2.
}
\description{
Layer for Coverage Plot.
}
\examples{
library(ggcoverage)
library(utils)
library(ggplot2)
meta.file <- system.file("extdata", "RNA-seq", "meta_info.csv", package = "ggcoverage")
sample.meta <- utils::read.csv(meta.file)
# track folder
track.folder <- system.file("extdata", "RNA-seq", package = "ggcoverage")
# load bigwig file
track.df <- LoadTrackFile(
  track.folder = track.folder, format = "bw",
  meta.info = sample.meta
)
ggplot() +
  geom_coverage(data = track.df, color = "auto", mark.region = NULL)
}
