% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair-links.R
\name{pair_links}
\alias{pair_links}
\alias{range_link}
\title{Helper function to create pairs of observation groups}
\usage{
pair_links(..., .handle_missing = "error", .reorder = NULL)

range_link(point1, point2)
}
\arguments{
\item{...}{<\link[rlang:dyn-dots]{dyn-dots}> A list of formulas, where each side
of the formula should be an \code{integer} or \code{character} index of the original
data, or a \code{range_link()} object defining the linked observations. Use
\code{NULL} to indicate no link on that side. You can also combine these by
wrapping them into a single \code{list()}. If only the left-hand side of the
formula exists, you can input it directly. For integer indices, wrap them
with \code{\link[=I]{I()}} to use the ordering from the layout. You can also use
\code{\link[ggplot2:waiver]{waiver()}} to inherit values from the other group.}

\item{.handle_missing}{A string of \code{"error"} or \code{"remove"}
indicates the action for handling missing observations.}

\item{.reorder}{A string of \code{"hand1"} or \code{"hand2"} indicating
whether to reorder the input links to follow the specified layout ordering.}

\item{point1, point2}{A single integer or character index, defining the lower
and higher bounds of the range. For integer indices, wrap them with \code{\link[=I]{I()}}
to indicate the ordered index by the layout.}
}
\description{
\code{\link[=ggmark]{ggmark()}} and \code{\link[=cross_link]{cross_link()}} allow users to add links between
observations. These functions help define the linked observations. The
selected pairs will either be linked together, or each group in the pair will
be linked separately to the same plot area.
\itemize{
\item \code{pair_links}: Helper function to create pairs of observation groups.
\item \code{range_link}: Helper function to create a range of observations.
}
}
\examples{
x <- pair_links(
    # group on the left hand only
    c("a", "b"),
    # normally, integer index will be interpreted as the index of the
    # origianl data
    1:2,
    # wrapped with `I()` indicate` the integer index is ordering of the
    # layout
    I(1:2),
    range_link(1, 6),
    range_link("a", "b"),
    # group on the right hand only
    ~ 1:2,
    ~ c("a", "b"),
    ~ range_link(1, 6),
    # group on the both side
    range_link(1, 6) ~ c("a", "b"),
    # waiver() indicates the right hand is the same of the left hand
    range_link(1, 6) ~ waiver(),
    # the same for the left hand
    waiver() ~ 1:2,
    ~NULL # an empty link
)
x

# we can modify it as usual list
x[[1]] <- NULL # remove the first link
x$a <- ~LETTERS
x

# modify with a list
x[1:2] <- list(~ c("a", "b"), ~ range_link("a", "b"))
x
}
