% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/craft-align-phylo.R
\name{align_phylo}
\alias{align_phylo}
\title{Plot Phylogenetics tree}
\usage{
align_phylo(
  phylo,
  ...,
  ladderize = NULL,
  type = "rectangle",
  center = FALSE,
  tree_type = NULL,
  no_axes = NULL,
  active = NULL,
  size = NULL
)
}
\arguments{
\item{phylo}{A \code{\link[ape:as.phylo]{phylo}} object.}

\item{...}{<\link[rlang:dyn-dots]{dyn-dots}> Additional arguments passed to
\code{\link[ggplot2:geom_segment]{geom_segment()}}.}

\item{ladderize}{A single string of \code{"left"} or \code{"right"},
indicating whether to ladderize the tree. Ladderizing arranges the tree so
that the smallest clade is positioned on the \code{"right"} or the \code{"left"}. By
default, \code{NULL} means the tree will not be ladderized.}

\item{type}{A string indicates the plot type, \code{"rectangle"} or \code{"triangle"}.}

\item{center}{A boolean value. if \code{TRUE}, nodes are plotted centered with
respect to all leaves/tips in the branch. Otherwise (default), plot them in
the middle of the direct child nodes.}

\item{tree_type}{A single string, one of
\code{"phylogram"} or \code{"cladogram"}, indicating the type of tree.
\itemize{
\item \code{phylogram}: Represents a phylogenetic tree where branch lengths indicate
evolutionary distance or time.
\item \code{cladogram}: Represents a tree where branch lengths are not used, or the
branches do not reflect evolutionary time.
}

Usually, you don't need to modify this.}

\item{no_axes}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Logical; if \code{TRUE},
removes axes elements for the alignment axis using \code{\link[=theme_no_axes]{theme_no_axes()}}. By
default, will use the option-
\code{"ggalign.align_no_axes"}.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}

\item{size}{The relative size of the plot, can be specified as a
\code{\link[grid:unit]{unit()}}. Note that for \code{\link[=circle_layout]{circle_layout()}}, all size values
will be interpreted as relative sizes, as this layout type adjusts based on
the available space in the circular arrangement.}
}
\description{
Plot Phylogenetics tree
}
