% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align-phylo.R
\name{fortify_matrix.phylo}
\alias{fortify_matrix.phylo}
\title{Build a matrix from \code{phylo} object}
\usage{
\method{fortify_matrix}{phylo}(data, ..., data_arg = caller_arg(data), call = NULL)
}
\arguments{
\item{data}{A \code{\link[ape:as.phylo]{phylo}} object.}

\item{...}{These dots are for future extensions and must be empty.}

\item{data_arg}{The argument name for \code{data}. Developers can use it to
improve messages. Not used by the user.}

\item{call}{The execution environment where \code{data} and other arguments for
the method are collected. Developers can use it to improve messages. Not
used by the user.}
}
\value{
A one-column matrix where the tip labels are the values, and the row
names will also be the tip labels.
}
\description{
This method allows a \code{\link[ape:as.phylo]{phylo}} object to be
directly input into \code{stack_discrete()} or \code{circle_discrete()}. This makes it
possible to add \code{\link[=align_phylo]{align_phylo()}} to the stack independently, as
\code{\link[=align_phylo]{align_phylo()}} requires the layout to have labels.
}
\seealso{
Other \code{\link[=fortify_matrix]{fortify_matrix()}} methods:
\code{\link{fortify_matrix.GISTIC}()},
\code{\link{fortify_matrix.MAF}()},
\code{\link{fortify_matrix.default}()},
\code{\link{fortify_matrix.list_upset}()},
\code{\link{fortify_matrix.matrix}()},
\code{\link{fortify_matrix.matrix_oncoplot}()},
\code{\link{fortify_matrix.matrix_upset}()}
}
\concept{fortify_matrix}
