% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggalign.R
\name{ggalign}
\alias{ggalign}
\title{Add ggplot by Aligning discrete or continuous variable}
\usage{
ggalign(
  data = waiver(),
  mapping = aes(),
  ...,
  size = NULL,
  no_axes = NULL,
  active = NULL
)
}
\arguments{
\item{data}{The following options can be used:
\itemize{
\item \code{NULL}: No data is set.
\item \code{\link[ggplot2:waiver]{waiver()}}: Inherits the data from the layout matrix.
\item A \code{function} (including purrr-like lambda syntax): Applied to the layout
matrix to transform the data before use. To transform the final plot
data, please use \code{\link[=scheme_data]{scheme_data()}}.
\item A \code{matrix}, \code{data.frame}, or atomic vector.
}}

\item{mapping}{Default list of aesthetic mappings to use for plot.
If not specified, must be supplied in each layer added to the plot.}

\item{...}{<\link[rlang:dyn-dots]{dyn-dots}> Additional arguments passed to
\code{\link[=fortify_data_frame]{fortify_data_frame()}}.}

\item{size}{The relative size of the plot, can be specified as a
\code{\link[grid:unit]{unit()}}. Note that for \code{\link[=circle_layout]{circle_layout()}}, all size values
will be interpreted as relative sizes, as this layout type adjusts based on
the available space in the circular arrangement.}

\item{no_axes}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Logical; if \code{TRUE},
removes axes elements for the alignment axis using \code{\link[=theme_no_axes]{theme_no_axes()}}. By
default, will use the option-
\code{"ggalign.align_no_axes"}.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{ggalign()} is similar to \code{ggplot} in that it initializes a \code{ggplot} data and
\code{mapping}. \code{ggalign()} allowing you to provide data in various formats,
including matrices, data frames, or simple vectors. By default, it will
inherit from the layout. If a function, it will apply with the layout matrix.
\code{ggalign()} focuses on integrating plots into a layout by aligning the axes.
}
\section{ggplot2 specification}{

\code{ggalign} initializes a ggplot object. The underlying data is created using
\code{\link[=fortify_data_frame]{fortify_data_frame()}}. Please refer to it for more details.

When aligning discrete variables, \code{ggalign()} always applies a default
mapping for the axis of the data index in the layout. Specifically:
\itemize{
\item \code{aes(y = .data$.y)} is used for the horizontal \code{stack_layout()} (including
left and right annotations).
\item \code{aes(x = .data$.x)} is used for the vertical \code{stack_layout()} (including
top and bottom annotations) and \code{circle_layout()}.
}

The following columns will be added to the data frame to align discrete
variables:
\itemize{
\item \code{.panel}: The panel for the aligned axis. Refers to the \code{x-axis} for
vertical \code{stack_layout()} (including top and bottom annotations), and the
\code{y-axis} for horizontal \code{stack_layout()} (including left and right
annotations).
\item \code{.names} (\code{\link[vctrs:vec_names]{vec_names()}}) and \code{.index}
(\code{\link[vctrs:vec_size]{vec_size()}}/\code{\link[=NROW]{NROW()}}): Character names (if
available) and the integer index of the original data.
\item \code{.x}/\code{.y} and \code{.discrete_x}/\code{.discrete_y}: Integer indices for \code{x}/\code{y}
coordinates, and a factor of the data labels (only applicable when names
exist).
}

It is recommended to use \code{.x}/\code{.y}, or \code{.discrete_x}/\code{.discrete_y} as the
\code{x}/\code{y} mapping.

If the data inherits from \code{\link[=quad_layout]{quad_layout()}}/\code{\link[=ggheatmap]{ggheatmap()}}, additional
columns will be added:
\itemize{
\item \code{.extra_panel}: Provides the panel information for the column (left or
right annotation) or row (top or bottom annotation).
\item \code{.extra_index}: The index information for the column (left or right
annotation) or row (top or bottom annotation).
}
}

\section{Discrete Axis Alignment}{

It is important to note that we consider rows as observations, meaning
\code{vec_size(data)}/\code{NROW(data)} must match the number of observations along the
axis used for alignment (x-axis for a vertical stack layout, y-axis for a
horizontal stack layout).
}

\examples{
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    anno_top() +
    ggalign() +
    geom_point(aes(y = value))

ggheatmap(matrix(rnorm(81), nrow = 9)) +
    anno_top(size = 0.5) +
    align_dendro(k = 3L) +
    ggalign(data = NULL, size = 0.2) +
    geom_tile(aes(y = 1L, fill = .panel))

}
