% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify-data-frame.R
\name{fortify_data_frame}
\alias{fortify_data_frame}
\title{Build a data frame}
\usage{
fortify_data_frame(data, ..., data_arg = caller_arg(data), call = NULL)
}
\arguments{
\item{data}{An object to be converted to a data frame.}

\item{...}{Arguments passed to methods.}

\item{data_arg}{The argument name for \code{data}. Developers can use it to
improve messages. Not used by the user.}

\item{call}{The execution environment where \code{data} and other arguments for
the method are collected, e.g., \code{\link[rlang:stack]{caller_env()}}.
Developers can use it to improve messages. Not used by the user.}
}
\value{
A data frame.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function converts various objects to a data frame.
}
\seealso{
\itemize{
\item \code{\link[=fortify_data_frame.default]{fortify_data_frame.default()}}
\item \code{\link[=fortify_data_frame.character]{fortify_data_frame.character()}}/\code{\link[=fortify_data_frame.numeric]{fortify_data_frame.numeric()}}
\item \code{\link[=fortify_data_frame.matrix]{fortify_data_frame.matrix()}}
\item \code{\link[=fortify_data_frame.dendrogram]{fortify_data_frame.dendrogram()}}
\item \code{\link[=fortify_data_frame.phylo]{fortify_data_frame.phylo()}}
}
}
