% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignpatch-align_plots.R
\name{layout_annotation}
\alias{layout_annotation}
\title{Modify components of the layout}
\usage{
layout_annotation(theme = waiver(), ...)
}
\arguments{
\item{theme}{A \code{\link[ggplot2:theme]{theme()}} used to render the \code{guides},
\code{title}, \code{subtitle}, \code{caption}, \code{margins}, \code{patch.title}, \code{panel.border}, and
\code{background}. If \code{NULL} (default), will inherit from the parent \code{layout}.}

\item{...}{These dots are for future extensions and must be empty.}
}
\description{
\itemize{
\item modify the theme of the layout
}
}
\details{
\itemize{
\item \code{guides}, \code{patch.title}, \code{panel.border}, and \code{background} will always be
added even for the nested \code{alignpatches} object.
\item \code{title}, \code{subtitle}, \code{caption}, and \code{margins} will be added for the
top-level \code{alignpatches} object only.
}
}
\examples{
p1 <- ggplot(mtcars) +
    geom_point(aes(mpg, disp))
p2 <- ggplot(mtcars) +
    geom_boxplot(aes(gear, disp, group = gear))
p3 <- ggplot(mtcars) +
    geom_bar(aes(gear)) +
    facet_wrap(~cyl)
align_plots(
    p1 + theme(plot.background = element_blank()),
    p2 + theme(plot.background = element_blank()),
    p3 + theme(plot.background = element_blank())
) +
    layout_annotation(
        theme = theme(plot.background = element_rect(fill = "red"))
    )
}
