% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignpatch-title.R
\name{patch_titles}
\alias{patch_titles}
\title{Add patch titles to plot borders}
\usage{
patch_titles(
  top = waiver(),
  left = waiver(),
  bottom = waiver(),
  right = waiver()
)
}
\arguments{
\item{top, left, bottom, right}{A string specifying the title to be added to the
top, left, bottom, and right border of the plot.}
}
\value{
A \link[ggplot2:labs]{labs} object to be added to ggplot.
}
\description{
This function extends ggplot2's title functionality, allowing you to add
titles to each border of the plot: top, left, bottom, and right.
}
\details{
You can also use \link[ggplot2:labs]{labs()} to specify titles for the top, left,
bottom, and right borders of the plot.

The appearance and alignment of these patch titles can be customized using
\link[ggplot2:theme]{theme()}:
\itemize{
\item \code{plot.patch_title}/\verb{plot.patch_title.*}: Controls the text appearance of
patch titles. By default, \code{plot.patch_title} inherit from \code{plot.title}, and
settings for each border will inherit from \code{plot.patch_title}, with the
exception of the \code{angle} property, which is not inherited.
\item \code{plot.patch_title.position}/\verb{plot.patch_title.position.*}: Determines the
alignment of the patch titles. By default, \code{plot.patch_title.position}
inherit from \code{plot.title.position}, and settings for each border will
inherit from \code{plot.patch_title}. The value \code{"panel"} aligns the patch
titles with the plot panels. Setting this to \code{"plot"} aligns the patch
title with the entire plot (excluding margins and plot tags).
}
}
