% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align-.R
\docType{data}
\name{align}
\alias{align}
\alias{Align}
\title{Create a new \code{Align} object}
\usage{
align(
  align_class,
  params,
  data,
  size = NULL,
  free_labs = waiver(),
  free_spaces = waiver(),
  plot_data = waiver(),
  limits = TRUE,
  facet = TRUE,
  set_context = TRUE,
  order = NULL,
  name = NULL,
  check.param = TRUE,
  call = caller_call()
)
}
\arguments{
\item{data}{A matrix, a data frame, or even a simple vector that will be
converted into a one-column matrix. If the \code{data} argument is set to \code{NULL},
the \verb{align_*} will use the \code{layout} data. Additionally, the \code{data} argument
can also accept a function (purrr-like lambda is also okay), which will be
applied with the \code{layout} data,

It is important to note that all \verb{align_*} functions consider the \code{rows} as
the observations. It means the \code{NROW(data)} must return the same number with
the parallel \code{layout} axis.
\itemize{
\item \code{layout_heatmap}: for column annotation, the \code{layout} data will be
transposed before using (If data is a \code{function}, it will be applied with
the transposed matrix). This is necessary because column annotation uses
heatmap columns as observations, but we need rows.
\item \code{layout_stack}: the \code{layout} data will be used as it is since we place all
plots along a single axis.
}}

\item{size}{Plot size, can be an \link[grid:unit]{unit} object.}

\item{free_labs}{A boolean value or a string containing one or more of
\code{"t"},\code{"l"},\code{"b"},and \code{"r"} indicates which axis title should be free from
alignment. If \code{NULL}, all axis title will be aligned. Default: "tlbr".}

\item{free_spaces}{A character specifies the ggplot elements which won't
count space sizes when alignment. If \code{NULL} (default), no space will be
removed. See \code{\link[=free_space]{free_space()}} for allowed values.}

\item{plot_data}{A function used to transform the plot data before rendering.
By default, it'll inherit from the parent layout. If no parent layout, the
default is to not modify the data. Use \code{NULL}, if you don't want to modify
anything.

Used to modify the data after layout has been created, but before the data is
handled of to the ggplot2 for rendering. Use this hook if the you needs
change the default data for all \code{geoms}.}

\item{limits}{A boolean value indicates whether to set the layout limtis for
the plot.}

\item{facet}{A boolean value indicates whether to set the layout facet for
the plot. If this is \code{FALSE}, \code{limits} will always be \code{FALSE} too.}

\item{set_context}{A single boolean value indicates whether to set the active
context to current plot. If \code{TRUE}, all subsequent ggplot elements will be
added into this plot.}

\item{order}{An single integer for the layout order.}

\item{name}{A string of the plot name. Used to switch the active context in
\code{\link[=hmanno]{hmanno()}} or \code{\link[=stack_active]{stack_active()}}.}

\item{check.param}{A single boolean value indicates whether to check the
supplied parameters and warn.}

\item{call}{The \code{call} used to construct the \code{Align} for reporting messages.}
}
\value{
A new \code{Align} object.
}
\description{
\code{Align} object will act with the \code{layout} object, reorder or split the
observations, some of them can also add plot components into the \code{layout}
object.
}
\section{Align}{

Each of the \verb{Align*} objects is just a \link[ggplot2:ggproto]{ggproto()} object,
descended from the top-level \code{Align}, and each implements various
methods and fields.

To create a new type of \verb{Align*} object, you typically will want to
override one or more of the following:
\itemize{
\item \code{setup_params}: Prepare parameter or check parameters used by this
annotation.
\item \code{setup_data}: Prepare data used by this annotation.
\item \code{compute}: A method used to compute statistics.
\item \code{layout}: A method used to group heamap rows/columns into panel or
reorder heamtap rows/columns.
\item \code{draw}: A method used to draw the plot. Must return a \code{ggplot} object.
}
}

\examples{
align_gg()
align_dendro()
}
\keyword{datasets}
\keyword{internal}
