% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_interaction.R
\name{gg_interaction}
\alias{gg_interaction}
\alias{gg_interaction.randomForest}
\alias{gg_interaction.rfsrc}
\title{Minimal Depth Variable Interaction data object (\code{\link[randomForestSRC]{find.interaction}}).}
\usage{
gg_interaction(object, ...)
}
\arguments{
\item{object}{a \code{\link[randomForestSRC]{rfsrc}} object or the output from the
\code{\link[randomForestSRC]{find.interaction}} function call.}

\item{...}{optional extra arguments passed to \code{\link[randomForestSRC]{find.interaction}}.}
}
\value{
\code{gg_interaction} object
}
\description{
Converts the matrix returned from
\code{\link[randomForestSRC]{find.interaction}} to a \code{data.frame} and add attributes 
for S3 identification. 
If passed  a \code{\link[randomForestSRC]{rfsrc}} object, \code{gg_interaction} first runs 
the \code{\link[randomForestSRC]{find.interaction}} 
function with all optional arguments.
}
\examples{
## Examples from randomForestSRC package... 
## ------------------------------------------------------------
## find interactions, classification setting
## ------------------------------------------------------------
## -------- iris data
## iris.obj <- rfsrc(Species ~., data = iris)
## TODO: VIMP interactions not handled yet....
## randomForestSRC::find.interaction(iris.obj, method = "vimp", nrep = 3)
## interaction_iris <- randomForestSRC::find.interaction(iris.obj)
data(interaction_iris, package="ggRandomForests")
gg_dta <- gg_interaction(interaction_iris)

plot(gg_dta, xvar="Petal.Width")
plot(gg_dta, panel=TRUE)

## ------------------------------------------------------------
## find interactions, regression setting
## ------------------------------------------------------------
\dontrun{
## -------- air quality data
## airq.obj <- rfsrc(Ozone ~ ., data = airquality)
##
## TODO: VIMP interactions not handled yet....
## randomForestSRC::find.interaction(airq.obj, method = "vimp", nrep = 3)
## interaction_airq <- randomForestSRC::find.interaction(airq.obj)
data(interaction_airq, package="ggRandomForests")
gg_dta <- gg_interaction(interaction_airq)

plot(gg_dta, xvar="Temp")
plot(gg_dta, xvar="Solar.R")

plot(gg_dta, panel=TRUE)
}

## -------- Boston data
data(interaction_Boston, package="ggRandomForests")
gg_dta <- gg_interaction(interaction_Boston)

plot(gg_dta, panel=TRUE)

\dontrun{
## -------- mtcars data
data(interaction_mtcars, package="ggRandomForests")
gg_dta <- gg_interaction(interaction_mtcars)

plot(gg_dta, panel=TRUE)
}
\dontrun{
## ------------------------------------------------------------
## find interactions, survival setting
## ------------------------------------------------------------
## -------- pbc data
## data(pbc, package = "randomForestSRC") 
## pbc.obj <- rfsrc(Surv(days,status) ~ ., pbc, nsplit = 10)
## interaction_pbc <- randomForestSRC::find.interaction(pbc.obj, nvar = 8)
data(interaction_pbc, package="ggRandomForests")
gg_dta <- gg_interaction(interaction_pbc)

plot(gg_dta, xvar="bili")
plot(gg_dta, panel=TRUE)

## -------- veteran data
data(interaction_veteran, package="ggRandomForests")
gg_dta <- gg_interaction(interaction_veteran)

plot(gg_dta, panel=TRUE)
}

}
\references{
Ishwaran H. (2007). Variable importance in binary regression trees and 
forests, Electronic J. Statist., 1:519-537.

Ishwaran H., Kogalur U.B., Gorodeski E.Z, Minn A.J. and Lauer M.S. (2010).
High-dimensional variable selection for survival data. J. Amer. Statist. 
Assoc., 105:205-217.

Ishwaran H., Kogalur U.B., Chen X. and Minn A.J. (2011). Random survival 
forests for high-dimensional data. Statist. Anal. Data Mining, 4:115-132.
}
\seealso{
\code{\link[randomForestSRC]{rfsrc}}
\code{\link[randomForestSRC]{find.interaction}} 
\code{\link[randomForestSRC]{max.subtree}}
\code{\link[randomForestSRC]{var.select}}
\code{\link[randomForestSRC]{vimp}}
\code{\link{plot.gg_interaction}}
}
