% Generated by roxygen2 (4.0.2): do not edit by hand
\name{gg_survival.ggRandomForests}
\alias{gg_survival}
\alias{gg_survival.ggRandomForests}
\title{Nonparametric survival estimates.}
\usage{
gg_survival.ggRandomForests(interval, censor, strat = NULL, data,
  type = c("kaplan", "nelson"), ...)
}
\arguments{
\item{interval}{name of the interval variable in the training dataset.}

\item{censor}{name of the censoring variable in the training dataset.}

\item{strat}{stratifying variable in the training dataset, defaults to NULL}

\item{data}{name of the training data.frame}

\item{type}{one of ("kaplan","nelson"), defaults to kaplan-meier}

\item{...}{extra arguments passed to kaplan or nelson functions.}
}
\value{
A gg_survival object created using the non-parametric kaplan-meier or
nelson-aalon estimators.
}
\description{
Nonparametric survival estimates.
}
\details{
gg_survival is a wrapper function for both generating nonparametric
survival estimates using either nelson-aalen or kaplan-meier estimates.
}
\examples{
data(pbc, package="randomForestSRC")
pbc$time <- pbc$days/364.25

# This is the same as kaplan
gg_dta <- gg_survival(interval="time", censor="status",
                     data=pbc)

plot(gg_dta, error="none")
plot(gg_dta)

# Stratified on treatment variable.
gg_dta <- gg_survival(interval="time", censor="status",
                     data=pbc, strat="treatment")

plot(gg_dta, error="none")
plot(gg_dta)

# ...with smaller confidence limits.
gg_dta <- gg_survival(interval="time", censor="status",
                     data=pbc, strat="treatment", conf.int=.68)

plot(gg_dta, error="lines")
}
\seealso{
\code{\link{kaplan}} \code{\link{nelson}} \code{\link{plot.gg_survival}}
}

