% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_depth.R
\name{get_depth}
\alias{get_depth}
\title{Extract depth for coordinates from a raster bathymetry dataset}
\usage{
get_depth(
  data,
  bathy.style = "raster_continuous",
  lon = NULL,
  lat = NULL,
  shapefile = "DecimalDegree",
  proj.in = 4326,
  bind = TRUE,
  depth.col = "depth",
  verbose = FALSE
)
}
\arguments{
\item{data}{Data frame or \link[sf:sf]{sf} object containing geographic coordinates.}

\item{bathy.style}{Character defining the \link{basemap} bathymetry raster which should be used for the depth extraction. Valid alternatives: \code{"raster_binned"} (or \code{"rb"}), \code{"raster_continuous"} (or \code{"rc"}; default), or \code{"raster_user"} (or \code{"ru"}).}

\item{lon, lat}{Either the names of the longitude and latitude columns in \code{data} or \code{NULL} to \link[=guess_coordinate_columns]{guess the longitude and/or latitude columns} in \code{data}.}

\item{shapefile}{Land shape to which distances should be calculated. Either a character argument referring to a name of pre-made shapefiles in \code{\link{shapefile_list}}, a single \link[sf]{sf} or \code{sp} polygons object object or \code{NULL} to enable automatic definition of the land shapes based on \code{data}. Set to \code{"DecimalDegree"} by default which enables great circle distances using \link[sf]{s2} features assuming a spherical Earth (as a contrast to earlier versions of the function which used flat Earth).}

\item{proj.in}{\code{\link[sf:st_crs]{coordinate reference system}} of \code{data}.}

\item{bind}{Logical indicating whether \code{x} should be returned with the distances (\code{TRUE}, default) or should the distances be returned as vector (\code{FALSE}).}

\item{depth.col}{The name of the depth column, if \code{bind = TRUE}. Defaults to "depth".}

\item{verbose}{Logical indicating whether information about the process should be returned as messages. Set to \code{FALSE} to make the function silent.}
}
\value{
Returns a vector if \code{bind = FALSE}, otherwise a data frame. The depths are given in a new column defined by the \code{dist.col} argument. The distances are \strong{kilometers}. \code{NA} distance means that the position is on land.
}
\description{
Extracts depth from \link{basemap} bathymetry raster dataset for coordinates in a data frame
}
\details{
Uses the \code{\link[stars]{st_extract}} function to extract values from \link{basemap} bathymetry raster grids. Does not work for vector bathymetries.
}
\examples{
\dontrun{
dt <- data.frame(lon = seq(-20, 80, length.out = 41), lat = 50:90)
dt <- get_depth(dt)
qmap(dt, color = depth) + scale_color_viridis_c()
}
}
\author{
Mikko Vihtakari
}
