% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singboost_plot.R
\name{singboost.plot}
\alias{singboost.plot}
\title{Plot function for the SingBoost coefficient paths}
\usage{
singboost.plot(mod, M, m_iter, subnames = FALSE)
}
\arguments{
\item{mod}{singboost object.}

\item{M}{An integer between 2 and \code{m_iter}. Indicates that in every M-th iteration, a singular iteration will be
performed. Default is 10.}

\item{m_iter}{Number of SingBoost iterations. Default is 100.}

\item{subnames}{Use it only if the variable names are of the form ''letter plus number''. Better just ignore it.}
}
\value{
Nothing. Plots SingBoost coefficient paths
}
\description{
Plot function for the SingBoost coefficient paths
}
\examples{
{glmres<-glmboost(Sepal.Length~.,iris)
glmres
attributes(varimp(glmres))$self
attributes(varimp(glmres))$var
firis<-as.formula(Sepal.Length~.)
Xiris<-model.matrix(firis,iris)
Diris<-data.frame(Xiris[,-1],iris$Sepal.Length)
plot(glmres)
singpath<-path.singboost(Diris)
singboost.plot(singpath,10,100,subnames=FALSE)}

}
