% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_isatpanel.R
\name{robust_isatpanel}
\alias{robust_isatpanel}
\title{Get robust Standard Errors for the isatpanel result}
\usage{
robust_isatpanel(
  object,
  robust = TRUE,
  HAC = FALSE,
  lag = NULL,
  type = "HC0",
  cluster = "group"
)
}
\arguments{
\item{object}{An isatpanel object}

\item{robust}{Logical (TRUE or FALSE). Should the Standard Errors be robustified for Heterogeneity? This uses \link[plm:vcovHC.plm]{plm::vcovHC} with the specified type (default is "HC0").}

\item{HAC}{Should Heteroscedasticity and Autocorrelation Robust Standard Errors be used? This uses \link[plm:vcovNW]{plm::vcovNW}, which uses the Newey-West estimator.}

\item{lag}{Maximum Number of Lags to be used with \link[plm:vcovNW]{plm::vcovNW} using the Newey-West estimator. Cannot be specified when HAC = FALSE. Default is \code{NULL}.}

\item{type}{Character string. Type of Robust procedure e.g. 'HC0' for White SE or 'HC3' for Lang.}

\item{cluster}{Should an object with clustered S.E. be included? Choose between 'group' or 'time' or FALSE. Uses \link[plm:vcovHC.plm]{plm::vcovHC} with the cluster argument.}
}
\value{
A list with robust estimates
}
\description{
Get robust Standard Errors for the isatpanel result
}
\examples{
\donttest{
data(EU_emissions_road)

# Group specification
EU15 <- c("Austria", "Germany", "Denmark", "Spain", "Finland", "Belgium",
         "France", "United Kingdom", "Ireland", "Italy", "Luxembourg",
         "Netherlands", "Greece", "Portugal", "Sweden")

# Prepare sample and data
EU_emissions_road_short <- EU_emissions_road[
EU_emissions_road$country \%in\% EU15 &
EU_emissions_road$year >= 2000,
]

# Run
result <- isatpanel(
  data = EU_emissions_road_short,
  formula = ltransport.emissions ~ lgdp + I(lgdp^2) + lpop,
  index = c("country", "year"),
  effect = "twoways",
  fesis = TRUE,
  plot = FALSE,
  t.pval = 0.01
)
robust_isatpanel(result)
}

}
