% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_post}
\alias{get_post}
\title{RPC call helper method.}
\usage{
get_post(method, params = list())
}
\arguments{
\item{method}{String - Method to call in the Geth node.}

\item{params}{Array of Strings - Params that are passed to the method.}
}
\value{
Object - Response from the Geth node.
}
\description{
\code{get_post} returns the response of the RPC call in the Geth node.
}
\examples{
\donttest{
get_post('eth_accounts')
get_post('debug_verbosity', list(3))
get_post('debug_goTrace', list('file.log', 5))
}

}
\seealso{
Other utils functions: \code{\link{dec_to_hex}},
  \code{\link{get_network_id}},
  \code{\link{get_rpc_address}}, \code{\link{hex_to_dec}},
  \code{\link{hex_to_text}}, \code{\link{is.wholenumber}},
  \code{\link{process_block}}, \code{\link{process_log}},
  \code{\link{process_receipt}},
  \code{\link{process_transaction}},
  \code{\link{set_network_id}},
  \code{\link{set_rpc_address}}, \code{\link{text_to_hex}}
}
\concept{utils functions}
