% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_km_fit}
\alias{plot_km_fit}
\title{Kaplan Meier Plot of Curve-Fit}
\usage{
plot_km_fit(
  fit,
  data,
  Time = "Time",
  Event = "Event",
  censoringOne = FALSE,
  CI = 0.95,
  colour_CI = TRUE,
  maxT = NULL,
  xlim = NULL,
  ylim = c(0, 1),
  main = "Kaplan Meier Curve Fit Plot",
  fit_col = 2,
  km_col = 1,
  area_col = "skyblue",
  CI_col = 4,
  CI_lty = 2,
  no_legend = FALSE,
  legend_position = c("bottom_left", "top_right"),
  ...
)
}
\arguments{
\item{fit}{Full output list from event_prediction(), fit_tte_data() or fit_KM().}

\item{data}{Name of patient-level data set, used to generate the KM plot.}

\item{Time}{The column name for the times. Default is "Time"}

\item{Event}{The column name for the events column (i.e. the binary variable denoting events vs censorings). Default is "Event"}

\item{censoringOne}{Specify whether censoring is denoted in the Event column by a one (TRUE) or zero (FALSE). Default=FALSE (censorings denoted by 0, events by 1)}

\item{CI}{Number between 0 and 1 for the size of Kaplan Meier confidence interval to calculate. Default is 0.95 (95 percent confidence interval).}

\item{colour_CI}{Boolean for whether to colour the fitting confidence interval area. Default=TRUE (colour area)}

\item{maxT}{Maximum time to calculate point estimate and CIs up to. Default=NULL (Calculate up to last time in patient data)}

\item{xlim}{Standard graphical parameter for x-axis limits. Default=NULL (Plots from 0 to maximum patient time)}

\item{ylim}{Graphical parameter for y-axis limits. Default=c(0,1) (Plots survival function from 0 to 1)}

\item{main}{String for plot title. Default="Kaplan Meier Curve Fit Plot"}

\item{fit_col}{Colour for fitting curve Default=2 (red)}

\item{km_col}{Colour for km curve Default=1 (black)}

\item{area_col}{Colour for CI area Default="skyblue" (sky blue)}

\item{CI_col}{Colour for CI Default=4 (blue)}

\item{CI_lty}{Line type for CI Default=2 (dashed)}

\item{no_legend}{Boolean to turn off legend. Default is FALSE; legend shown.}

\item{legend_position}{String with "top_right", or "bottom_left", corresponding to legend position in power plot. (Default="bottom_left").}

\item{...}{Additional graphical parameters.}
}
\value{
Returns NULL
}
\description{
This function creates a Kaplan Meier plot with the fitted curve from the output of event_prediction(), fit_tte_data() or fit_KM().\cr
Where available, it will include fitting confidence intervals based upon the variance derived by the delta method.\cr
Options are available to customise inclusion.\cr
}
\examples{
recruit <- PieceR(matrix(c(rep(1,12),10,15,25,30,45,60,55,50,65,60,55,30),ncol=2),1)
trial_long <- simulate_trials(active_ecurve=Weibull(50,0.8),control_ecurve=Weibull(50,0.8),
rcurve=recruit,fix_events=200, iterations=1,seed=12345,detailed_output=TRUE)
trial_short <- set_assess_time(data=trial_long,time=10,detailed_output = FALSE)

maxtime <- max(ceiling(trial_long[,"Assess"]))
events <- rep(NA,maxtime)
for (i in 1:maxtime){events[i] <- sum(1-set_assess_time(trial_long,i)[,"Censored"])}

predictions <- event_prediction(data=trial_short, Event="Censored", censoringOne=TRUE, 
type="Weibull", rcurve=recruit, max_time=60, cond_Events=49, cond_NatRisk=451, 
cond_Time=10, units="Months")

plot_km_fit(fit=predictions,data=trial_short,Event="Censored",censoringOne=TRUE,maxT=70)

}
\author{
James Bell
}
