% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_functions.R
\name{analyse_sim}
\alias{analyse_sim}
\title{Analyse simulations of time-to-event data using arbitrary event, censoring and recruitment distributions.}
\usage{
analyse_sim(data, LR = TRUE, RMST = NULL, landmark = NULL,
  stratum = "", parallel_cores = 1)
}
\arguments{
\item{data}{Output file from simulate_trials. Only simulate_trials output is supported, in either "list" or "matrix" format.}

\item{LR}{Requests log-rank test and Cox regression. Default=TRUE}

\item{RMST}{Requests Restricted Mean Survival Time analysis with specified (positive integer) restriction time, leave NULL for no analysis. This uses the survRM2 package. Default=NULL (no RMST analysis).}

\item{landmark}{Requests Landmark analysis at specified (positive integer) time, leave NULL for no analysis. Default=NULL (no landmark analysis).}

\item{stratum}{Specify name of column of a stratification factor and turn on stratified (LR/LM) and covariate-adjusted (Cox/RMST) analysis. By default, "", and no stratification.}

\item{parallel_cores}{Positive integer specifying number of cores to use. If 1 specified then no parallel processing. Default=1 (no parallel processing).}
}
\value{
Returns a table with one row per simulation. Table contains the following columns:
\itemize{
 \item{"HR"}{ Cox Hazard Ratio (LR/Cox analysis only)}
 \item{"LogHR"}{ Cox Log Hazard Ratio (LR/Cox analysis only)}
 \item{"LogHR_SE"}{ Cox Standard Error of log Hazard Ratio (LR/Cox analysis only)}
 \item{"HR_Z"}{ Cox Z-Score (LR/Cox analysis only)}
 \item{"HR_P"}{ 1-sided Cox p-value (LR/Cox analysis only)}
 \item{"LR_Z"}{ Log-Rank Test Z-Score (LR/Cox analysis only)}
 \item{"LR_P"}{ 1-sided Log-Rank Test p-value (LR/Cox analysis only)}
 \item{"Events_Active"}{ Events in Active arm (LR/Cox analysis only)}
 \item{"Events_Control"}{ Events in Control arm (LR/Cox analysis only)}
 \item{"RMST_Time"}{ RMST restriction time (RMST analysis only)}
 \item{"RMST_Active"}{ RMST for Active arm (RMST analysis only)}
 \item{"RMST_Active_SE"}{ RMST Standard Error for Active arm (RMST analysis only)}
 \item{"RMST_Control"}{ RMST for Control arm (RMST analysis only)}
 \item{"RMST_Control_SE"}{ RMST Standard Error for Control arm (RMST analysis only)}
 \item{"RMST_Delta"}{ RMST difference between arms active-control (RMST analysis only)}
 \item{"RMST_Delta_SE"}{ RMST difference between arms Standard Error (RMST analysis only)}
 \item{"RMST_Z"}{ Z-score for RMST (RMST analysis only)}
 \item{"RMST_P"}{ 1-sided RMST p-value (RMST analysis only)}
 \item{"LM_Time"}{ Landmark time, i.e. time of survival function comparison  (Landmark analysis only)}
 \item{"LM_Active"}{ Survival function for active arm at landmark time (Landmark analysis only)}
 \item{"LM_Active_SE"}{ Greenwood standard error for active arm at landmark time (Landmark analysis only)}
 \item{"LM_Control"}{ Survival function for control arm at landmark time (Landmark analysis only)}
 \item{"LM_Control_SE"}{ Greenwood standard error for control arm at landmark time (Landmark analysis only)}
 \item{"LM_Delta"}{ Survival function difference between arms active-control at landmark time (Landmark analysis only)}
 \item{"LM_Delta_SE"}{ Greenwood standard error for difference between arms at landmark time (Landmark analysis only)}
 \item{"LM_Z"}{ Z-score for landmark analysis (Landmark analysis only)}
 \item{"LM_P"}{ 1-sided landmark analysis p-value (Landmark analysis only)}
}
}
\description{
Function for analysing simulated time-to-event trial data produced by simulate_trials.\cr
Automatically reads in format from simulate_trials.\cr
Performs log rank test and Cox regression analysis by default, but can also/instead choose RMST and/or landmark analyses.\cr
Option is available to perform stratified analysis using the "stratum" argument.\cr
If a stratum is specified, it will be included as a covariate in Cox and RMST analysis, and as a stratum in a stratified log-rank test and an inverse-precision-weighted landmark test.
Analysis is typically the slowest part of simulation, so parallel processing using the doParallel package is built in, enabled using the "parallel" argument.\cr
Use of parallel processing recommended for >10000 simulations. Ensure that the number of cores specified does not exceed number of threads provided by hardware.
}
\examples{
example_sim <- simulate_trials(active_ecurve=Weibull(250,0.8),control_ecurve=Weibull(100,1),
rcurve=LinearR(12,100,100), assess=20,iterations=2,seed=12345,detailed_output=TRUE)

example_analysis1 <- analyse_sim(example_sim)
example_analysis2 <- analyse_sim(data=example_sim,RMST=15,landmark=15)

example_strat_sim <- simulate_trials_strata(stratum_probs=c(0.5,0.5),
active_ecurve=c(Weibull(250,0.8),Weibull(100,1)), control_ecurve=Weibull(100,1),
rcurve=LinearR(12,100,100),assess=20,iterations=2,seed=12345)

example_strat_analysis <- analyse_sim(data=example_strat_sim,RMST=15,landmark=15,stratum="Stratum")
}
\author{
James Bell
}
