% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s4_architecture.R
\docType{class}
\name{Curve-class}
\alias{Curve-class}
\title{Curve Class for defining distributions}
\description{
This class allows distributions to be defined. It contains all information needed to reproduce a distribution.\cr
References to functions that store the PDF, CDF and random number generator.\cr
Parameters are also stored.
}
\section{Slots}{

\describe{
\item{\code{type}}{Type of Curve (character). Typically the distribution name.}

\item{\code{PDF}}{Name of the PDF function describing the Curve.}

\item{\code{CDF}}{Name of the CDF function describing the Curve.}

\item{\code{RF}}{Name of the random generator function describing the Curve.}

\item{\code{paramno}}{Number of parameters required to define the distribution.}

\item{\code{pnames}}{Names of parameters defining the distribution. Should be a vector of length paramno.}

\item{\code{pvalue}}{Values of parameters defining the distribution. Should be a list of length paramno.}
}}

\examples{
new("Curve", type="ExampleCurve",PDF="name_of_pdf_function",CDF="name_of_CDF_function",
RF="name_of_random_draw_function", paramno=2,pnames=c('param1','param2'),pvalue=list(1,2))
}
\author{
James Bell
}
