% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rebase.R
\name{git_reset}
\alias{git_reset}
\alias{git_reset_hard}
\alias{git_reset_soft}
\alias{git_reset_mixed}
\title{Reset your repo to a previous state}
\usage{
git_reset_hard(ref = "HEAD", repo = ".")

git_reset_soft(ref = "HEAD", repo = ".")

git_reset_mixed(ref = "HEAD", repo = ".")
}
\arguments{
\item{ref}{string with a branch/tag/commit}

\item{repo}{The path to the git repository. If the directory is not a
repository, parent directories are considered (see \link{git_find}). To disable
this search, provide the filepath protected with \code{\link[=I]{I()}}. When using this
parameter, always explicitly call by name (i.e. \verb{repo = }) because future
versions of gert may have additional parameters.}
}
\description{
\itemize{
\item \code{git_reset_hard()} reverts to a point in history
\item \code{git_reset_soft()} uncommits changes, but keeps the chsange uncommited
\item \code{git_reset_mixed()} performs a simple \verb{git reset}.
}
}
\seealso{
Other git: 
\code{\link{git_archive}},
\code{\link{git_branch}()},
\code{\link{git_commit}()},
\code{\link{git_config}()},
\code{\link{git_diff}()},
\code{\link{git_fetch}()},
\code{\link{git_ignore}},
\code{\link{git_merge}()},
\code{\link{git_rebase}()},
\code{\link{git_remote}},
\code{\link{git_repo}},
\code{\link{git_signature}()},
\code{\link{git_stash}},
\code{\link{git_tag}}
}
\concept{git}
