% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gboot_block.R
\name{gboot_block}
\alias{gboot_block}
\title{Block bootstrap}
\usage{
gboot_block(data,var,model,B,L1,L2)
}
\arguments{
\item{data}{object of the class geodata.}

\item{var}{object of the class variogram.}

\item{model}{object of the class variomodel.}

\item{B}{number of the bootstrap that will be performed (default B=1000).}

\item{L1}{number of cuts in the vertical (L1xL2 blocks).}

\item{L2}{number of cuts in the horizontal (L1xL2 blocks).}
}
\value{
\bold{variogram_boot} gives the variogram of each bootstrap.

\bold{variogram_or} gives the original variogram.

\bold{pars_boot} gives the estimatives of the nugget, sill, contribution, range and practical range for each bootstrap.

\bold{pars_or} gives the original estimatives of the nugget, sill, contribution, range and practical range.

Invalid arguments will return an error message.
}
\description{
Performs a bootstrap based on subdivision of data in blocks
}
\details{
The algorithm for the block bootstrap is an adaptation of the time series bootstrap.
Consider that your data presents the second order stationarity, so, we can subdivide them into small blocks.
The steps of the algorithm are:

\enumerate{
\item Subdivide the data into L1xL2 blocks;
\item Realocate each block with probability\eqn{\frac{1}{L1L2}} ;
\item Calculate the new variogram from the new data;
\item Calculate and save the statistics of interest;
\item Return to step 2 and repeat the process at least 1000 times.
}
}
\examples{

\dontrun{
# Example 1

## transforming the data.frame in an object of class geodata
data<- as.geodata(soilmoisture)

points(data) ## data visualization

var<- variog(data, max.dist = 140) ## Obtaining the variogram
plot(var)

## Fitting the model
mod<- variofit(var,ini.cov.pars = c(2,80),nugget = 2,cov.model = "sph")
lines(mod, col=2, lwd=2) ##fitted model

## Bootstrap procedure

boot<- gboot_block(data,var,mod,B=10, L1=2, L2=2)
## For better Confidence Interval, try B=1000

gboot_CI(boot,digits = 4) ## Bootstrap Confidence Interval

gboot_plot(boot) ## Bootstrap Variogram plot

# Example 2

## transforming the data.frame in an object of class geodata
data<- as.geodata(NVDI)

points(data) ## data visualization

var<- variog(data, max.dist = 18) ## Obtaining the variogram
plot(var)

## Fitting the model
mod<- variofit(var,ini.cov.pars = c(0.003,6),nugget = 0.003,cov.model = "gaus")
lines(mod, col=2, lwd=2) ##fitted model

## Bootstrap procedure

boot<- boot<- gboot_block(data,var,mod,B=10, L1=2, L2=2)
## For better Confidence interval, try B=1000

gboot_CI(boot,digits = 4) ## Bootstrap Confidence Interval

gboot_plot(boot) ## Bootstrap Variogram plot
}

}
\references{
DAVISON, A.C.; HINKLEY, D. V. Bootstrap Methods and their Application. [s.l.] Cambridge University Press, 1997. p. 582
}
\author{
Diogo Francisco Rossoni \email{dfrossoni@uem.br}

Vinicius Basseto Felix \email{felix_prot@hotmail.com}
}
\keyword{Block}
\keyword{Bootstrap}
\keyword{Spatial}
