% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSVersion.R
\docType{class}
\name{GSVersion}
\alias{GSVersion}
\title{A GeoServer version}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling a GeoServer version
}
\description{
This class allows to grab the GeoServer version. By default, a 
tentative is made to fetch version from web admin default page, since Geoserver 
REST API did not support GET operation for the Geoserver version in past releases
of Geoserver.
}
\details{
Geoserver REST API - Geoserver Version
}
\examples{
\dontrun{
version <- GSVersion$new(
             url = "http://localhost:8080/geoserver",
             user = "admin", pwd = "geoserver"
           )
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\keyword{version}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{version}}{version}

\item{\code{value}}{value}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSVersion-new}{\code{GSVersion$new()}}
\item \href{#method-GSVersion-lowerThan}{\code{GSVersion$lowerThan()}}
\item \href{#method-GSVersion-greaterThan}{\code{GSVersion$greaterThan()}}
\item \href{#method-GSVersion-equalTo}{\code{GSVersion$equalTo()}}
\item \href{#method-GSVersion-clone}{\code{GSVersion$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSVersion-new"></a>}}
\if{latex}{\out{\hypertarget{method-GSVersion-new}{}}}
\subsection{Method \code{new()}}{
Initializes an object of class \link{GSVersion}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSVersion$new(url, user, pwd)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{url}

\item{\code{user}}{user}

\item{\code{pwd}}{pwd}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSVersion-lowerThan"></a>}}
\if{latex}{\out{\hypertarget{method-GSVersion-lowerThan}{}}}
\subsection{Method \code{lowerThan()}}{
Compares to a version and returns TRUE if it is lower, FALSE otherwise
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSVersion$lowerThan(version)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version}}{version}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if lower, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSVersion-greaterThan"></a>}}
\if{latex}{\out{\hypertarget{method-GSVersion-greaterThan}{}}}
\subsection{Method \code{greaterThan()}}{
Compares to a version and returns TRUE if it is greater, FALSE otherwise
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSVersion$greaterThan(version)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version}}{version}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if greater, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSVersion-equalTo"></a>}}
\if{latex}{\out{\hypertarget{method-GSVersion-equalTo}{}}}
\subsection{Method \code{equalTo()}}{
Compares to a version and returns TRUE if it is equal, FALSE otherwise
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSVersion$equalTo(version)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version}}{version}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if equal, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSVersion-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSVersion-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSVersion$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
