% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalIntegration.r
\name{globalIntegration}
\alias{globalIntegration}
\title{Quantify global integration relative to self-similarity}
\usage{
globalIntegration(A, ShowPlot = TRUE)
}
\arguments{
\item{A}{3D array (p1 x k x n) containing Procrustes shape variables}

\item{ShowPlot}{A logical value indicating whether or not the plot should be returned}
}
\description{
Function quantifies the overall level of morphological integration for a set of Procrustes shape variables
}
\details{
The function quantifies the overall level of morphological integration for a set of 
Procrustes shape coordinates. It is assumed that the landmarks have previously been 
aligned using Generalized Procrustes Analysis (GPA) [e.g., with \code{\link{gpagen}}]. 
Based on the set of aligned specimens, the function estimates the set of bending energies at various
spatial scales, and plots the log of the variance of the partial warps versus the log of their
corresponding bending energies (Bookstein 2015). The slope of a regression of these data provides information
regarding the degree of overall morphological integration (or lack thereof).

A slope of negative one corresponds to self-similarity, implying that patterns of shape variation are
similar across spatial scales. Steeper slopes (i.e., those more extreme than -1.0) correspond to data that are globally
integrated, while shallower slopes (between -1 and 0) correspond to data that are 'disintegrated (see Bookstein 2015). Isotropic data
will have an expected slope of zero.
}
\examples{
\dontrun{
data(plethodon) 
Y.gpa <- gpagen(plethodon$land)    #GPA-alignment    

globalIntegration(Y.gpa$coords)
}
}
\references{
Bookstein, F. L. 2015. Integration, disintegration, and self-similarity: 
Characterizing the scales of shape variation in landmark data. Evol. Biol.42(4): 395-426.
}
\author{
Dean Adams
}
\keyword{analysis}
