% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.physign.z.r
\name{compare.physignal.z}
\alias{compare.physignal.z}
\title{Comparisons of Phylogenetic Signal Effect Sizes}
\usage{
compare.physignal.z(..., two.tailed = TRUE)
}
\arguments{
\item{...}{saved analyses of class physignal.z}

\item{two.tailed}{A logical value to indicate whether a two-tailed test (typical and default) should be performed.}
}
\value{
An object of class compare.physignal.z, returns a list of the following
\item{sample.z}{A vector of effect sizes for each sample.}
\item{sample.r.sd}{A vector of standard deviations for each sampling distribution (following Box-Cox transformation).}
\item{pairwise.z}{A matrix of pairwise, two-sample z scores between all pairs of effect sizes.}
\item{pairwise.p}{A matrix of corresponding P-values.}
}
\description{
Function performs an analysis to compare the effect sizes of two or more phylogenetic effect sizes
}
\details{
The function statistically compares the effect sizes of two or more \code{\link{physignal.z}} analyses.  
This can be performed on different traits from the same tree, same or different traits from different
trees, or modules of landmark configurations.
 
To use this function, perform \code{\link{physignal.z}} on as many samples as desired.  
Any number of objects of class physignal.z can be input.  Note that some values of Z can be NaN,
if the scaling parameter, lambda, is optimized at 0.  In these cases, the standard error is also 0,
and pairwise comparisons might not make sense.
}
\examples{

# Example: Compare phylogenetic signal of head components in Plethodon

data(plethspecies) 
Y.gpa<-gpagen(plethspecies$land)    #GPA-alignment

## landmarks of the jaw and cranium
jaw <- 1:5
cranium <- 6:11

PS.jaw <- physignal.z(A = Y.gpa$coords[jaw,,], phy = plethspecies$phy, 
lambda = "front", PAC.no = 7, iter=999)

PS.cranium <- physignal.z(A = Y.gpa$coords[cranium,,], phy = plethspecies$phy, 
lambda = "front", PAC.no = 7, iter=999)

PS.list <-list(PS.jaw, PS.cranium)
names(PS.list) <- c("jaw", "cranium")

PS.Z <- compare.physignal.z(PS.list)
summary(PS.Z)

}
\references{
Collyer,  M.L., E.K. Baken, & D.C. Adams.  2022. A standardized effect size for evaluating
and comparing the strength of phylogenetic signal. Methods in Ecology and Evolution. 13:367-382.
}
\author{
Michael Collyer
}
\keyword{analysis}
