% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrayspecs.r
\name{arrayspecs}
\alias{arrayspecs}
\title{Convert landmark data matrix into array (p x k x n)}
\usage{
arrayspecs(A, p, k, sep = NULL)
}
\arguments{
\item{A}{A matrix containing landmark coordinates for a set of specimens}

\item{p}{Number of landmarks}

\item{k}{Number of dimensions (2 or 3)}

\item{sep}{An optional argument to attempt to separate variable names into 
landmark dimension
and landmark number variables.  For example, X.1, Y.1, Z.1, X.2, Y.2, Z.2, 
..., can be separated 
with sep = ".", such that rows of landmark configurations are labeled 1, 2, 
3, ..., and columns
are labeled X, Y, Z. Note, for variables, X1, Y1, Z1, X2, Y2, Z2, ...,
where no separator is evident, use sep = "".  Any illogical separation 
argument will result in unlabeled
variables.  If sep = NULL (the default), unlabeled variables are forced.  
This is a good idea if the original matrix
has landmarks out of order (as the the landmark labels might not sort as 
expected).}
}
\value{
Function returns a 3D array (p x k x n), where p is the number of 
landmark points, k is the
number of landmark dimensions (2 or 3), and n is the number of specimens. 
The third dimension of
this array contains names for each specimen if specified in the original 
input matrix.
}
\description{
Convert a matrix of landmark coordinates into a three-dimensional array
}
\details{
This function converts a matrix of landmark coordinates into a 3D array (p x 
k x n), 
 which is the required input format for many functions in geomorph. 
 The input matrix can be arranged such that the coordinates
 of each landmark are found on a separate row, or that each row contains all 
 landmark 
 coordinates for a single specimen.
}
\examples{
x<-matrix(rnorm(18),nrow=3)  # Random triangles (all coordinates on same 
 # row for each triangle)
arrayspecs(x,3,2) 
 
x2<-matrix(rnorm(18),ncol=2) # Random triangles (each landmark on its 
# own row)
arrayspecs(x2,3,2)
}
\seealso{
\code{\link{two.d.array}}
}
\author{
Dean Adams & Mike Collyer
}
\keyword{utilities}
