% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/define.sliders.3d.r
\name{define.sliders.3d}
\alias{define.sliders.3d}
\title{Select points to "slide" along three-dimensional curves.}
\usage{
define.sliders.3d(spec, nsliders, surfsliders = FALSE)
}
\arguments{
\item{spec}{Name of specimen, as an object matrix containing 3D landmark coordinates}

\item{nsliders}{Number of landmarks to be semilandmarks that slide along curves}

\item{surfsliders}{Logical If spec contains landmarks that are "surface sliders",
made by \code{\link{buildtemplate}}, "surfslide.csv" should be in working directory}
}
\value{
Function returns a 'curves x 3' matrix containing the landmark address of the curve sliders, indicating the
points between which the selected point will "slide". Written to the working directory is this matrix as "curveslide.csv".
Matrix (or "curveslide.csv") is designed for use by \code{\link{gpagen}} during GPA.
}
\description{
An interactive function to define which digitized landmarks of an '*.nts' file
will "slide" along three-dimensional (3D) curves.
}
\details{
Function takes a matrix of digitized landmark coordinates, such as made by \code{\link{digit.fixed}}, or \code{\link{buildtemplate}}
 and helps user choose which landmarks will be treated as "curve sliders" in Generalized Procrustes analysis
 \code{\link{gpagen}}. This type of semilandmark "slides" along curves lacking known landmarks
 (see Bookstein 1997 for algorithm details).
 Each sliding semilandmark ("sliders") will slide between two designated points, along a line
 tangent to the specified curvature.

\subsection{Selection}{
Choosing which landmarks will be sliders involves landmark selection using a mouse in the rgl plot window.
With a standard 3-button (PC) buildtemplate uses:
\enumerate{
 \item the RIGHT mouse button (primary) to choose points to be defined as sliders,
 \item the LEFT mouse button (secondary) is used to rotate mesh,
 \item the mouse SCROLLER (third/middle) is used to zoom in and out.
}
NOTE: Digitizing functions on MACINTOSH computers using a standard 3-button mice works as specified. Macs using platform
specific single button mice, XQuartz must be configured: go to Preferences > Input > tick "Emulate three button mouse":
\enumerate{
 \item press button to rotate 3D mesh,
 \item press button while pressing COMMAND key to select points to be defined as sliders,
 \item press button while pressing OPTION key to adjust mesh perspective.
 \item the mouse SCROLLER or trackpad two finger scroll is used to zoom in an out.
 }

To define the sliders, for each sliding landmark along the curve in the format 'before-slider-after':
\enumerate{
 \item Click to choose the first landmark between which semi-landmark will "slide",
 \item Click to choose sliding landmark,
 \item Click to choose the last landmark between which semi-landmark will "slide",
Screen will show lines connecting the three landmarks, and will highlight the sliding semilandmark in red.
}
This procedure is overlapping, so for example a curve defined by a sequence of semilandmarks,
the user must select the 2nd point of the first three to be the 1st for the next
e.g. 1 2 3 then 2 3 4, etc.
}
}
\author{
Erik Otarola-Castillo & Emma Sherratt
}
\references{
Bookstein, F. J. 1997 Landmark Methods for Forms without Landmarks: Morphometrics of
Group Differences in Outline Shape. Medical Image Analysis 1(3):225-243.
}
\seealso{
\code{\link{digit.fixed}}, \code{\link{digitsurface}}, \code{\link{gpagen}}
}
\keyword{utilities}

