\name{fixed.angle}
\alias{fixed.angle}
\title{Rotate a subset of 2D landmarks to common articulation angle}
\usage{
  fixed.angle(A, art.pt = NULL, angle.pts = NULL,
    rot.pts = NULL, angle = 0)
}
\arguments{
  \item{A}{An array (p x k x n) containing landmark
  coordinates for a set of specimens}

  \item{art.pt}{A number specifying which landmark is the
  articulation point between the two landmark subsets}

  \item{angle.pts}{A vector containing numbers specifying
  which two points used to define the angle (one per
  subset)}

  \item{rot.pts}{A vector containing numbers specifying
  which landmarks are in the subset to be rotated}

  \item{angle}{An optional value specifying the additional
  amount by which the rotation should be augmented (in
  radians)}
}
\value{
  Function returns a (p x k x n) array of landmark
  coordinates.
}
\description{
  A function for rotating a subset of landmarks so that the
  articulation angle between subsets is constant
}
\details{
  This function standardizes the angle between two subsets
  of landmarks for a set of specimens. The approach assumes
  a simple hinge-point articulation between the two
  subsets, and rotates all specimens such that the angle
  between landmark subsets is equal across specimens (see
  Adams 1999).  As a default, the mean angle is used,
  though the user may specify an additional amount by which
  this may be augmented.

  Presently, the function is only implemented for
  two-dimensional landmark data.
}
\examples{
#Example using Plethodon
#Articulation point is landmark 1, rotate mandibular landmarks (2-5) relative to cranium

data(plethspecies)
fixed.angle(plethspecies$land,art.pt=1,angle.pts=c(5,6),rot.pts=c(2,3,4,5))
}
\author{
  Dean Adams
}
\references{
  Adams, D. C. 1999. Methods for shape analysis of landmark
  data from articulated structures. Evolutionary Ecology
  Research. 1:959-970.
}

