% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inhulln.R
\name{inhulln}
\alias{inhulln}
\title{Test if points lie in convex hull}
\usage{
inhulln(ch, p)
}
\arguments{
\item{ch}{Convex hull produced using \code{\link{convhulln}}}

\item{p}{An \eqn{M}-by-\eqn{N} matrix of points to test.
The rows of \code{p} represent \eqn{M} points in \eqn{N}-dimensional space.}
}
\value{
A boolean vector with \eqn{M} elements
}
\description{
Tests if a set of points lies within a convex hull, returning a
boolean vector in which each element is \code{TRUE} if the
corresponding point lies within the hull and \code{FALSE} if it
lies outwith the hull or on one of its facets.
}
\examples{
p <- cbind(c(-1, -1, 1), c(-1, 1, -1))
ch <- convhulln(p)
## First point should be in the hull; last two outside
inhulln(ch, rbind(c(-0.5, -0.5),
                  c( 1  ,  1),
                  c(10  ,  0)))

## Test hypercube
p <- rbox(4, B=1)
ch <- convhulln(p)
tp <-  cbind(seq(-1.9, 1.9, by=0.2), 0, 0, 0)
pin <- inhulln(ch, tp)
## Points on x-axis should be in box only between -1 and 1
pin == (tp[,1] < 1 & tp[,1] > -1)
}
\seealso{
convhulln
}
\author{
David Sterratt
}
