% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seam.R
\name{seam_sew}
\alias{seam_sew}
\title{Suggest Edges to Connect Two Sides of a Border}
\usage{
seam_sew(shp, admin, seam, epsg = 3857)
}
\arguments{
\item{shp}{sf tibble where admin column is found}

\item{admin}{quoted name of administrative unit column}

\item{seam}{administrative units to filter by}

\item{epsg}{numeric EPSG code to planarize to. Default is 3857.}
}
\value{
tibble of edges connecting sides of a border
}
\description{
Suggest Edges to Connect Two Sides of a Border
}
\examples{
data("rockland")
data("orange")
data("nrcsd")

o_and_r <- rbind(orange, rockland)
o_and_r <- o_and_r \%>\% geo_filter(nrcsd) \%>\% geo_trim(nrcsd)
adj <- adjacency(o_and_r)

adds <- seam_sew(o_and_r, 'county', c('071', '087'))
adj <- adj \%>\% add_edge(adds$v1, adds$v2)

}
\concept{seam}
