% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjacency.R
\name{suggest_neighbors}
\alias{suggest_neighbors}
\title{Suggest Neighbors for Lonely Precincts}
\usage{
suggest_neighbors(shp, adjacency, idx, neighbors = 1)
}
\arguments{
\item{shp}{an sf shapefile}

\item{adjacency}{an adjacency list}

\item{idx}{Optional. Which indices to suggest neighbors for. If blank, suggests for those
with no neighbors.}

\item{neighbors}{number of neighbors to suggest}
}
\value{
tibble with two columns of suggested rows of shp to connect in adj
}
\description{
For precincts which have no adjacent precincts, this suggests the nearest precinct
as a friend to add. This is useful for when a small number of precincts are disconnected
from the remainder of the geography, such as an island.
}
\examples{
library(dplyr)
data(va18sub)
va18sub <- va18sub \%>\% filter(!VTDST \%in\% c('000516', '000510', '000505', '000518'))
adj <- adjacency(va18sub)
suggests <- suggest_neighbors(va18sub, adj)
adj <- adj \%>\% add_edge(v1 = suggests$x, v2 = suggests$y)

}
\concept{fix}
