% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_cells.R
\name{cells_to_gene_signature}
\alias{cells_to_gene_signature}
\title{Cells to Gene Signature}
\usage{
cells_to_gene_signature(
  queryValues,
  data,
  dataMeta,
  uniqueRowID = "",
  options = list(timeout = 10000)
)
}
\arguments{
\item{queryValues}{A vector of query values to search for cells.}

\item{data}{A data frame containing gene expression data to be mapped.}

\item{dataMeta}{A data frame containing metadata for each entry in \code{data}.}

\item{uniqueRowID}{The name of the column in \code{dataMeta} that uniquely identifies each row.}

\item{options}{A list of options for the API call, including endpoint and timeout settings.}
}
\value{
A list containing \code{data}, the final data frame with gene signatures, and
\code{mapping}, a data frame of gene to cell mappings.
}
\description{
Queries for cells based on given values, fetches genes associated with those cells,
and filters for unique gene identifiers based on specified criteria such as fold change.
This function streamlines the process of identifying significant gene signatures from
cell query results. The function further filters results based on a threshold
determined by the mean and standard deviation of foldChange values.
}
\examples{
\dontrun{
cells_to_gene_signature(
  queryValues = c("CL0001054", "CL0002397"),
  data = yourData,
  dataMeta = yourDataMeta,
  uniqueRowID = "yourUniqueIdentifierColumnName"
)
}
}
